﻿using VT.FW.DB;
using Mall.Common.Enum.User;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.User
{
    /// <summary>
    /// 商户用户表实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Member_User
    {

        /// <summary>
        /// Id
        /// </summary>        
        public int Id
        {
            get;
            set;
        }
        /// <summary>
        /// 用户名称
        /// </summary>        
        public string Name
        {
            get;
            set;
        }
        /// <summary>
        /// 别名
        /// </summary>        
        public string AliasName
        {
            get;
            set;
        }
        /// <summary>
        /// 头像
        /// </summary>        
        public string Photo
        {
            get;
            set;
        }
        /// <summary>
        /// 来源  1微信  2支付宝
        /// </summary>        
        public UserSourceEnum? Source
        {
            get;
            set;
        }
        /// <summary>
        /// 唯一识别码
        /// </summary>        
        public string OpenId
        {
            get;
            set;
        }
        /// <summary>
        /// 手机号码
        /// </summary>        
        public string Moblie
        {
            get;
            set;
        }
        /// <summary>
        /// 会员等级  0 普通 根据会员等级表
        /// </summary>        
        public int? MemberGrade
        {
            get;
            set;
        }
        /// <summary>
        /// 订单数量
        /// </summary>        
        public int? OrderNum
        {
            get;
            set;
        }
        /// <summary>
        /// 优惠卷数量
        /// </summary>        
        public int? CouponsNum
        {
            get;
            set;
        }
        /// <summary>
        /// 卡卷数量
        /// </summary>        
        public int? CardVolumeNum
        {
            get;
            set;
        }
        /// <summary>
        /// 余额
        /// </summary>        
        public decimal? Balance
        {
            get;
            set;
        }
        /// <summary>
        /// 积分
        /// </summary>        
        public int? Integral
        {
            get;
            set;
        }
        /// <summary>
        /// 总消费
        /// </summary>
        public decimal? TotalConsumption { get; set; }
        /// <summary>
        /// CreateDate
        /// </summary>        
        public DateTime? CreateDate
        {
            get;
            set;
        }
        /// <summary>
        /// 上级 0表示总部
        /// </summary>        
        public int? SuperiorId
        {
            get;
            set;
        }
        /// <summary>
        /// 黑名单  1是 0否
        /// </summary>        
        public int? Blacklist
        {
            get;
            set;
        }
        /// <summary>
        /// 是否是分销商  1是 2否
        /// </summary>
        public int IsDistributor { get; set; }
        /// <summary>
        /// 联系方式
        /// </summary>        
        public string ContactWay
        {
            get;
            set;
        }
        /// <summary>
        /// 备注
        /// </summary>        
        public string Remark
        {
            get;
            set;
        }
        /// <summary>
        /// 商户号id
        /// </summary>        
        public int TenantId
        {
            get;
            set;
        }
        /// <summary>
        /// 修改时间
        /// </summary>        
        public DateTime? UpdateDate
        {
            get;
            set;
        }
        /// <summary>
        /// 小程序id
        /// </summary>
        public int MallBaseId { get; set; }
        /// <summary>
        /// 秘钥
        /// </summary>
        public string SecretKey { get; set; }
        /// <summary>
        /// 成为下线条件
        /// </summary>
        public DistrbutorReferralsEnum? DownlineCondition { get; set; }
        /// <summary>
        /// 是否已成为下线  1是  2否
        /// </summary>
        public int? IsBeDownline { get; set; }
        /// <summary>
        /// 等待成为上线id
        /// </summary>
        public int? WaitSuperiorId { get; set; }
        /// <summary>
        /// 成为下线时间
        /// </summary>
        public DateTime? BeDownlineDate { get; set; }

        public int SmallShopId { get; set; }


        /// <summary>
        /// 公司毛利利润比例
        /// </summary>
        public decimal CompanyProfitRate { get; set; }

        /// <summary>
        /// 职位Id,(1-领队导游)
        /// </summary>
        public int PostId { get; set; }

        /// <summary>
        /// 类型
        /// </summary>
        public Common.Enum.Goods.GoodsPageTypeEnum? UserPageType { get; set; }

        /// <summary>
        /// 2020-10-28号新增  （微信小程序获取的手机号码）
        /// </summary>
        public string PhoneNum { get; set; }

        /// <summary>
        /// 是否结算用户，1-是  2020-11-10  Addd By:w
        /// </summary>
        public int IsSettlement { get; set; }

        /// <summary>
        /// 教育点数（针对购买直播产品）
        /// </summary>
        public int PointNum { get; set; }

        /// <summary>
        /// 教育学校id
        /// </summary>
        public int EduSchoolId { get; set; }

        /// <summary>
        /// 是否管理员  1是
        /// </summary>
        public int IsAdmin { get; set; }

        /// <summary>
        /// 是否显示用户资料(1-显示，0-不显示)
        /// </summary>
        public int IsShow { get; set; }

        /// <summary>
        /// 用户所属分组
        /// </summary>
        public string BelongGroupIds { get; set; }

        /// <summary>
        /// 查看次数
        /// </summary>
        public int LookTimes { get; set; }

        /// <summary>
        /// UnionId唯一Id
        /// </summary>
        public string Unoinid { get; set; }
    }
}
