﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.Assess;
using Mall.Model.Extend.Assess;
using System.Linq;
using VT.FW.DB.Dapper;

namespace Mall.Repository.Assess
{
    /// <summary>
    /// 估价商品仓储层
    /// </summary>
    public class RB_Assess_GoodsRepository : BaseRepository<RB_Assess_Goods>
    {

        /// <summary>
        /// 分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="dmodel">查询条件</param>
        /// <returns></returns>
        public List<RB_Assess_Goods_Extend> GetPageList(int pageIndex, int pageSize, out long rowCount, RB_Assess_Goods_Extend dmodel)
        {
            var parameters = new DynamicParameters();
            string where = $" 1=1 and e.{nameof(RB_Assess_Goods_Extend.Status)}=0 ";
            if (dmodel.TenantId > 0) {
                where += $@" and e.{nameof(RB_Assess_Goods_Extend.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and e.{nameof(RB_Assess_Goods_Extend.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.CategoryId > 0)
            {
                where += $@" and e.{nameof(RB_Assess_Goods_Extend.CategoryId)} ={dmodel.CategoryId}";
            }
            if (dmodel.BrandId > 0)
            {
                where += $@" and e.{nameof(RB_Assess_Goods_Extend.BrandId)} ={dmodel.BrandId}";
            }
            if (dmodel.UserId > 0)
            {
                where += $@" and e.{nameof(RB_Assess_Goods_Extend.UserId)} ={dmodel.UserId}";
            }
            if (!string.IsNullOrEmpty(dmodel.BrandName))
            {
                where += $@" and b.{nameof(RB_Assess_Brand_Extend.Name)} like @BrandName";
                parameters.Add("BrandName", "%" + dmodel.BrandName + "%");
            }
            if (dmodel.IsReply == 1)
            {
                where += $" and IFNULL(e.{nameof(RB_Assess_Goods_Extend.ReplyContent)},'') <>''";
            }
            else if (dmodel.IsReply == 2)
            {
                where += $" and IFNULL(e.{nameof(RB_Assess_Goods_Extend.ReplyContent)},'') =''";
            }

            string sql = $@"
select e.*,u.Name as UserName,u.Photo as EmpPhoto,c.Name as CategoryName,b.Name as BrandName 
from RB_Assess_Goods e inner join rb_member_user u on e.UserId = u.Id
    left join rb_assess_category c on e.CategoryId =c.Id
    left join rb_assess_brand b on e.BrandId = b.Id
where {where} order by e.Id desc";
            return GetPage<RB_Assess_Goods_Extend>(pageIndex, pageSize, out rowCount, sql, parameters).ToList();
        }

    }
}
