﻿using Mall.Model.Entity.BaseSetUp;
using Mall.Model.Extend.BaseSetUp;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Repository.BaseSetUp
{
    /// <summary>
    /// 营销中心插件配置仓储层
    /// </summary>
    public class RB_Marketing_ConfigRepository : BaseRepository<RB_Marketing_Config>
    {
        /// <summary>
        /// 获取营销中心插件配置列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Marketing_Config_Extend> GetMarketingConfigListRepository(RB_Marketing_Config_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append(@" SELECT * FROM RB_Marketing_Config WHERE 1=1 ");
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Marketing_Config_Extend.TenantId), query.TenantId);
                }
                return Get<RB_Marketing_Config_Extend>(builder.ToString()).ToList();
            }
            else
            {
                return new List<RB_Marketing_Config_Extend>();
            }
        }
    }
}