﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mall.Model.Entity.Coffee;
using Mall.Model.Extend.Education;
using VT.FW.DB.Dapper;

namespace Mall.Repository.Education
{

    /// <summary>
    /// 教育商品订单仓储
    /// </summary>
    public class RB_EduGoods_OrderRepository : BaseRepository<RB_Goods_Order>
    {
        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_Goods_Order_ViewModel> GetList(RB_Goods_Order_ViewModel demodel)
        {
            var parameters = new DynamicParameters();
            string where = $@" 1=1 and Status =0";

            if (demodel.Group_Id > 0)
            {
                where += $@" and {nameof(RB_Goods_Order_ViewModel.Group_Id)} ={demodel.Group_Id}";
            }
            if (demodel.MallBaseId > 0)
            {
                where += $@" and {nameof(RB_Goods_Order_ViewModel.MallBaseId)} ={demodel.MallBaseId}";
            }
            if (demodel.OrderStatus > 0)
            {
                where += $@" and {nameof(RB_Goods_Order_ViewModel.OrderStatus)} ={demodel.OrderStatus}";
            }
            if (demodel.OrderId > 0)
            {
                where += $@" and {nameof(RB_Goods_Order_ViewModel.OrderId)} ={demodel.OrderId}";
            }
            if (demodel.OrderType > 0)
            {
                where += $@" and {nameof(RB_Goods_Order_ViewModel.OrderType)} ={demodel.OrderType}";
            }
            if (demodel.MallOrderId > 0)
            {
                where += $@" and {nameof(RB_Goods_Order_ViewModel.MallOrderId)} ={demodel.MallOrderId}";
            }
            if (!string.IsNullOrEmpty(demodel.OrderNo))
            {
                where += $@" and {nameof(RB_Goods_Order_ViewModel.OrderNo)} like @OrderNo";
                parameters.Add("OrderNo", "%" + demodel.OrderNo.Trim() + "%");
            }
            if (demodel.UserType > 0)
            {
                where += $@" and {nameof(RB_Goods_Order_ViewModel.UserType)} ={demodel.UserType}";
            }

            string sql = $@" select * from RB_Goods_Order where {where} order by OrderId desc";
            return Get<RB_Goods_Order_ViewModel>(sql, parameters).ToList();
        }
    }
}
