﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mall.Common.Enum;
using Mall.Model.Entity.Finance;
using Mall.Model.Extend.Finance;

namespace Mall.Repository.Finance
{
    /// <summary>
    /// 财务单据明细仓储层
    /// </summary>
    public class RB_FinanceDetailRepository : BaseRepository<RB_FinanceDetail>
    {
        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_FinanceDetail); } }

        /// <summary>
        /// 币种表
        /// </summary>
        public string CTableName { get { return nameof(RB_Currency); } }
        /// <summary>
        /// 费用类型表
        /// </summary>
        public string TTableName { get { return nameof(RB_Costtype); } }

        /// <summary>
        /// 获取单据详情列表
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public List<RB_FinanceDetail_Extend> GetList(RB_FinanceDetail_Extend model)
        {
            string where = "";
            where += string.Format(" AND A." + nameof(RB_FinanceDetail.Status) + "={0} ", (int)DateStateEnum.Normal);
            if (model.FinanceId > 0)
            {
                where += string.Format(" AND A." + nameof(RB_FinanceDetail.FinanceId) + "={0} ", model.FinanceId);
            }
            if (!string.IsNullOrEmpty(model.CostIds))
            {
                where += string.Format(" AND A." + nameof(RB_FinanceDetail.CostTypeId) + " in({0}) ", model.CostIds);
            }
            if (!string.IsNullOrEmpty(model.FrIds))
            {
                where += string.Format(" AND A." + nameof(RB_FinanceDetail.FinanceId) + " in({0}) ", model.FrIds);
            }
            if (!string.IsNullOrEmpty(model.FdIds))
            {
                where += string.Format(" AND A." + nameof(RB_FinanceDetail.ID) + " in({0}) ", model.FdIds);
            }
            return Get<RB_FinanceDetail_Extend>(string.Format(@"select A.*,B.`Name` as CurrencyName,C.`Name` as CostTypeName from {0} A INNER JOIN {1} B on A.CurrencyId=B.ID INNER JOIN {2} C on A.CostTypeId=C.ID WHERE 1=1 {3} ", TableName, CTableName, TTableName, where)).ToList();
        }
    }
}
