﻿using Mall.Common.API;
using Mall.WebApi.Filter;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Mvc;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Net.Http;
using System.Security.Cryptography;
using System.Text;
using System.Threading.Tasks;

namespace Mall.WebApi.Controllers.Adapay
{

    [Route("api/[controller]/[action]")]
    [ApiExceptionFilter]
    [ApiController]
    [EnableCors("AllowCors")]
    public class MessageController : ControllerBase
    {
        /// <summary>
        /// 接口认证
        /// </summary>
        /// <param name="echostr"></param>
        /// <param name="signature"></param>
        /// <param name="timestamp"></param>
        /// <param name="nonce"></param>
        /// <returns></returns>
        [HttpGet]
        public bool CheckSignature(string echostr, string signature, string timestamp, string nonce)
        {
            string token = "jjsw";
            string queryStr = string.Format("echostr:{0}  signature:{1}  timestamp:{2} nonce:{3}", echostr, signature, timestamp, nonce);
            Common.Plugin.LogHelper.WriteInfo(queryStr);
            if (!CheckSignatureModule(token, signature, timestamp, nonce))
            {
                return false;
            }
            return true;
        }

        /// <summary>
        /// 接收客服消息
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public async Task<HttpResponseMessage> wx()
        {
             
            //var content = await Request.Content.ReadAsStringAsync();
 
            HttpResponseMessage responseMessage = new HttpResponseMessage();
            return responseMessage;
        }
        /// <summary>
        /// 验证微信签名
        /// </summary>
        private bool CheckSignatureModule(string token, string signature, string timestamp, string nonce)
        {
            string[] ArrTmp = { token, timestamp, nonce };
            Array.Sort(ArrTmp);
            string tmpStr = string.Join("", ArrTmp);
            var data = SHA1.Create().ComputeHash(Encoding.UTF8.GetBytes(tmpStr));
            Common.Plugin.LogHelper.Write("data:" + data);
            var sb = new StringBuilder();
            foreach (var t in data)
            {
                sb.Append(t.ToString("X2"));
            }
            tmpStr = sb.ToString();
            tmpStr = tmpStr.ToLower();

            if (tmpStr == signature)
            {
                return true;
            }
            else
            {
                return false;
            }
        }
    }
}
