﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Common.Enum;
using Mall.Common.Enum.TradePavilion;
using VT.FW.DB;

namespace Mall.Model.Entity.TradePavilion
{
    /// <summary>
    /// 榜单报名实体表
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_FirstShop_ListEnroll
    {
        /// <summary>
        /// Id
        /// </summary>
        public int Id { get; set; }

        /// <summary>
        /// 用户id
        /// </summary>
        public int UserId { get; set; }

        /// <summary>
        /// 类型  1品牌  2载体   3服务商
        /// </summary>
        public ListObjectTypeEnum ObjectType { get; set; }

        /// <summary>
        /// 表单内容
        /// </summary>
        public string Content { get; set; }

        /// <summary>
        /// 入榜评语
        /// </summary>
        public string Reviews { get; set; }

        /// <summary>
        /// 排名
        /// </summary>
        public int Rank { get; set; }

        /// <summary>
        /// 小奖章图片
        /// </summary>
        public string MedalImage { get; set; }

        /// <summary>
        /// 大奖章图片
        /// </summary>
        public string MedalImageBig { get; set; }

        /// <summary>
        /// 候选状态  1报名中  2候选  3淘汰 
        /// </summary>
        public int CandidateState { get; set; }

        /// <summary>
        /// 上榜状态  1上榜   2未上榜
        /// </summary>
        public int RankListState { get; set; }

        /// <summary>
        /// 删除状态
        /// </summary>
        public int Status { get; set; }

        /// <summary>
        /// 商户号id
        /// </summary>
        public int TenantId { get; set; }

        /// <summary>
        /// 小程序id
        /// </summary>
        public int MallBaseId { get; set; }

        /// <summary>
        /// 创建人
        /// </summary>
        public int CreateBy { get; set; }

        /// <summary>
        /// 创建时间
        /// </summary>
        public DateTime CreateDate { get; set; }

        /// <summary>
        /// 修改人
        /// </summary>
        public int UpdateBy { get; set; }

        /// <summary>
        /// 修改时间
        /// </summary>
        public DateTime UpdateDate { get; set; }

    }
}
