﻿using VT.FW.DB;
using Mall.Model.Entity.Property;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Extend.Property
{
    /// <summary>
    /// Rb_employee Entity Model
    /// </summary>    
    [Serializable]
    [DB(ConnectionName = "UserConnection")]
    public class RB_Employee_Extend : RB_Employee
    {
        /// <summary>
        /// op提成  被驳回的订单
        /// </summary>
        public string IsFinanceRejectOrder { get; set; }
        /// <summary>
        /// op提成  是否由财务单据被驳回  1是  其他否
        /// </summary>
        public int? IsFinanceReject { get; set; }
        /// <summary>
        /// op提成  未收齐款的订单
        /// </summary>
        public string IsNotCollectOrder { get; set; }
        /// <summary>
        /// op提成  是否未收齐款  1是  其他否
        /// </summary>
        public int? IsNotCollectMoney { get; set; }
        /// <summary>
        /// 有效的离职月份
        /// </summary>
        public string LeaveMonth { get; set; }
        /// <summary>
        /// 是否是部门负责人  1是
        /// </summary>
        public int? IsDepartmentManager { get; set; }
        /// <summary>
        /// 人员id
        /// </summary>
        public string EmployeeIds { get; set; }
        /// <summary>
        /// 集团名称
        /// </summary>
        public string GroupName { get; set; }

        /// <summary>
        /// 公司id
        /// </summary>
        public int CompanyId { get; set; }

        /// <summary>
        /// 公司id
        /// </summary>
        public int? BranchId { get; set; }

        /// <summary>
        ///多个部门id
        /// </summary>
        public string DepartmentIds { get; set; }

        /// <summary>
        /// 公司名称
        /// </summary>
        public string CompanyName { get; set; }

        /// <summary>
        /// 部门名称
        /// </summary>
        public string DepartmentName { get; set; }

        /// <summary>
        /// 职务名称
        /// </summary>
        public string PostName { get; set; }
        /// <summary>
        /// 三方映射账号
        /// </summary>
        public string OpenAccount { get; set; }

        /// <summary>
        /// 部门名称Id
        /// </summary>
        public string DepartmentID { get; set; }

        /// <summary>
        /// 里程
        /// </summary>
        public double distance { get; set; }

        /// <summary>
        /// 【查询使用】
        /// </summary>
        public string EndDate { get; set; }

        /// <summary>
        ///【查询使用】
        /// </summary>
        public string StartDate { get; set; }


        /// <summary>
        /// 是否应用分区 1是  2否
        /// </summary>
        public int? IsUseSubarea { get; set; }

        /// <summary>
        /// 部门及下级ids
        /// </summary>
        public string Departments { get; set; }

        /// <summary>
        /// 岗位ids  2019-05-16 Add By:w
        /// </summary>
        public string PostIds { get; set; }

        /// <summary>
        /// 领队/导游id
        /// </summary>
        public int LeaderId { get; set; }


        /// <summary>
        ///周冠军次数
        /// </summary>
        public int WeekChampion { get; set; }


        /// <summary>
        /// 综合得分
        /// </summary>
        public int SumScore { get; set; }

    }
}
