﻿using VT.FW.DB;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Extend.User
{
    /// <summary>
    /// 小程序扩展实体类
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_MiniProgram_Extend : Model.Entity.User.RB_MiniProgram
    {
        /// <summary>
        /// 用户数量
        /// </summary>
        public int UserNum { get; set; }

        /// <summary>
        /// 订单数量
        /// </summary>
        public int OrderNum { get; set; }

        /// <summary>
        /// 账号
        /// </summary>
        public string Account { get; set; }

        /// <summary>
        /// 手机号码
        /// </summary>
        public string MobilePhone { get; set; }

        /// <summary>
        /// 小程序有效期
        /// </summary>
        public string EffectiveDateStr
        {
            get
            {
                string str = "";
                if (this.IsEffective != null && this.IsEffective == 1)
                {
                    str = "永久有效";
                }
                else
                {
                    if (this.MallValidate != null)
                    {
                        str = Convert.ToDateTime(this.MallValidate).ToString("yyyy-MM-dd");
                    }
                }
                return str;
            }
        }

        /// <summary>
        /// 状态字符串
        /// </summary>
        public string StatusStr
        {
            get
            {
                string str = "正常";
                if (this.Status == 1)
                {
                    str = "禁用";
                }
                return str;
            }
        }

        /// <summary>
        /// 底部导航列表
        /// </summary>
        public List<RB_Miniprogram_Bottomnav_Extend> BottomTagList { get; set; }

        /// <summary>
        /// 小程序用户中心【收藏、足迹】菜单列表
        /// </summary>
        public List<RB_MiniProgram_UserCenterMenu_Extend> FavoriteFootMenuList { get; set; }

        /// <summary>
        /// 小程序用户中心【订单】菜单列表
        /// </summary>
        public List<RB_MiniProgram_UserCenterMenu_Extend> OrderMenuList { get; set; }

        /// <summary>
        /// 小程序用户中心【账户】菜单列表
        /// </summary>
        public List<RB_MiniProgram_UserCenterMenu_Extend> AccountMenuList { get; set; }

        /// <summary>
        /// 小程序用户中心【自定义】菜单列表
        /// </summary>
        public List<RB_MiniProgram_UserCenterMenu_Extend> SelfMenuList { get; set; }


        /// <summary>
        /// 获取可跳转小程序
        /// </summary>
        public string[] JumpAppIdList { get; set; }

        /// <summary>
        /// 小程序首页数据
        /// </summary>
        public List<HomeItem> HomeDataList { get; set; }

        /// <summary>
        /// 授权热区
        /// </summary>
        public List<AuthItem> AuthDataList { get; set; }
    }

    /// <summary>
    /// 授权热区
    /// </summary>
    public class AuthItem
    { 
        /// <summary>
        /// 是否选中，前台使用
        /// </summary>
        public bool IsChecked { get; set; }

        /// <summary>
        /// 起点X坐标
        /// </summary>
       public int defaultX { get; set; }

        /// <summary>
        /// 起点Y坐标
        /// </summary>
       public  int defaultY { get; set; }

        /// <summary>
        /// 热区高度
        /// </summary>
        public int height { get; set; }

        /// <summary>
        /// 是否关闭
        /// </summary>
        public bool is_close { get; set; }

        /// <summary>
        /// 距离左边位置
        /// </summary>
        public int left { get; set; }

        /// <summary>
        /// 链接
        /// </summary>
        public string link { get; set; }

        /// <summary>
        /// 取消或确认
        /// </summary>
        public string open_type { get; set; }

        /// <summary>
        /// 距离顶部距离
        /// </summary>
        public int top { get; set; }

        /// <summary>
        /// 宽度
        /// </summary>
        public int width { get; set; }
    }

    /// <summary>
    /// 首页数据项
    /// </summary>
    public class HomeItem
    { 
        /// <summary>
        /// 插件Key
        /// </summary>
       public string key { get; set; }

        /// <summary>
        /// 插件名称
        /// </summary>
        public string name { get; set; }

        /// <summary>
        /// 关系Id
        /// </summary>
        public int relation_id { get; set; }

        /// <summary>
        /// 是否可编辑[0-不可编辑,1-可编辑]
        /// </summary>
        public int is_edit { get; set; }

        /// <summary>
        /// 图片地址
        /// </summary>
        public string imgBg { get; set; }

        /// <summary>
        /// 图标一行显示个数【导航图标插件】
        /// </summary>
        public int row_num { get; set; }

        /// <summary>
        /// 插件permission_key【video、topic、coupon】
        /// </summary>
        public string permission_key { get; set; }

        /// <summary>
        /// 视频地址【视频插件、】
        /// </summary>
        public string video_url { get; set; }

        /// <summary>
        /// 公告内容
        /// </summary>
        public string NoticeContent { get; set; }

        /// <summary>
        /// 公告背景颜色
        /// </summary>
        public string notice_bg_color { get; set; }

        /// <summary>
        /// 公告文字颜色
        /// </summary>
        public string notice_text_color { get; set; }

        /// <summary>
        /// 公告图片
        /// </summary>
        public string notice_url { get; set; }

        /// <summary>
        /// 公告名称
        /// </summary>
        public string NoticeName { get; set; }

        /// <summary>
        /// 视频封面图【视频插件、】
        /// </summary>
        public string video_pic_url { get; set; }

 

        /// <summary>
        /// 专题显示数量【专题插件】
        /// </summary>
        public int topic_num { get; set; }

        /// <summary>
        /// 图标(1个专题)【专题插件】
        /// </summary>
        public string topic_url { get; set; }

        /// <summary>
        /// 图标(2个专题)【专题插件】
        /// </summary>
        public string topic_url_2 { get; set; }

        /// <summary>
        /// 专题标签图片【专题插件】
        /// </summary>
        public string label_url { get; set; }

        /// <summary>
        /// 已领取图
        /// </summary>
        public string coupon_url { get; set; }

        /// <summary>
        /// 未领取图（满减券）
        /// </summary>
        public string coupon_not_url { get; set; }

        /// <summary>
        /// 打折券未认领
        /// </summary>
        public string discount_not_url { get; set; }

    }
 
}
