﻿using Mall.Common.Plugin;
using Mall.Model.Entity.BaseSetUp;
using Mall.Model.Extend.BaseSetUp;
using Mall.Repository;
using Mall.Repository.BaseSetUp;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VT.FW.DB;

namespace Mall.Module.BaseSetUp
{
    /// <summary>
    /// 地区模块
    /// </summary>
    public class DestinationModule
    {
        private Rb_destinationRepository rb_DestinationRepository = new Rb_destinationRepository();

        /// <summary>
        /// 根据父节点编号获取子列表
        /// </summary>
        /// <param name="ParentID">父节点编号</param>
        /// <returns></returns>
        public List<RB_Destination_Extend> GetChildList(int ParentID)
        {
            RB_Destination_Extend where = new RB_Destination_Extend()
            {
                ParentID = ParentID
            };
            return rb_DestinationRepository.GetListExt(where);
        }

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <returns></returns>
        public List<RB_Destination_Extend> GetAllList()
        {
            return rb_DestinationRepository.GetAllDestinationList();
        }

        /// <summary>
        /// 新增修改地区
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool Set(RB_Destination model)
        {
            var flag = false;
            if (model.ID > 0)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    {nameof(RB_Destination.Name), model.Name},
                    {nameof(RB_Destination.EnName), model.EnName},
                    {nameof(RB_Destination.ParentID), model.ParentID},
                    {nameof(RB_Destination.CodeLevel), model.CodeLevel},
                    {nameof(RB_Destination.ThreeCode), model.ThreeCode},
                    {nameof(RB_Destination.FourCode), model.FourCode},
                    {nameof(RB_Destination.Images), model.Images},
                };
                if (model.Area != null && !string.IsNullOrEmpty(model.Area))
                {
                    fileds.Add(nameof(RB_Destination.Area), model.Area);
                }
                List<WhereHelper> whereHelpers = new List<WhereHelper>()
                {
                    new WhereHelper(){ FiledName=nameof(RB_Destination.ID),FiledValue=model.ID ,OperatorEnum=OperatorEnum.Equal}
                };
                flag = rb_DestinationRepository.Update(fileds, whereHelpers);
            }
            else
            {
                flag = rb_DestinationRepository.Insert(model) > 0;
            }
            return flag;
        }
    }
}
