﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Extend.User;
using Mall.Repository;
using Mall.Repository.MarketingCenter;
using Mall.Repository.User;
using VT.FW.DB;

namespace Mall.Module.User
{
    /// <summary>
    /// 小程序页面处理类
    /// </summary>
    public class MiniProgramPageModule
    {
        /// <summary>
        /// 小程序页面仓储层对象
        /// </summary>
        private readonly RB_MiniProgram_PageRepository miniProgram_PageRepository = new RB_MiniProgram_PageRepository();

        /// <summary>
        /// 小程序页面管理仓储层对象
        /// </summary>
        private readonly RB_Miniprogram_PageManageRepository miniprogram_PageManageRepository = new RB_Miniprogram_PageManageRepository();

        /// <summary>
        /// 自定义页面仓储层
        /// </summary>
        private readonly RB_Miniprogram_Page_TemplRepository miniprogram_Page_TemplRepository = new RB_Miniprogram_Page_TemplRepository();


        /// <summary>
        /// 根据查询条件获取小程序列表(单个)
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_MiniProgram_Page_Extend> GetMiniProgramPage_ListModule(RB_MiniProgram_Page_Extend query)
        {
            return miniProgram_PageRepository.GetListRepository(query);
        }

        /// <summary>
        /// 获取小程序分页列表(单个)
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_MiniProgram_Page_Extend> GetMiniProgramPage_PageListModule(int pageIndex, int pageSize, out long rowCount, RB_MiniProgram_Page_Extend query)
        {
            return miniProgram_PageRepository.GetPageListRepository(pageIndex, pageSize, out rowCount, query);
        }

        /// <summary>
        /// 新增修改小程序页面(单个)
        /// </summary>
        /// <param name="extModel"></param>
        /// <returns></returns>
        public bool SetMiniProgram_Page_Module(RB_MiniProgram_Page_Extend extModel)
        {
            bool flag = false;
            if (extModel.Id > 0)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    { nameof(RB_MiniProgram_Page_Extend.Id),extModel.Id},
                    { nameof(RB_MiniProgram_Page_Extend.MallBaseId),extModel.MallBaseId},
                    { nameof(RB_MiniProgram_Page_Extend.PageId),extModel.PageId},
             
                };
                flag = miniProgram_PageRepository.Update(fileds, new WhereHelper(nameof(RB_MiniProgram_Page_Extend.Id), extModel.Id));
            }
            else
            {
                int NewId = miniProgram_PageRepository.Insert(extModel);
                extModel.Id = NewId;
                flag = NewId > 0;
            }
            return flag;
        }

        /// <summary>
        /// 判断小程序是否存在页面
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public int CheckMiniProgram_Page(RB_MiniProgram_Page_Extend query)
        {
            List<WhereHelper> list = new List<WhereHelper>()
            {
             new WhereHelper (nameof(RB_MiniProgram_Page_Extend.PageId),query.PageId),
             new WhereHelper (nameof(RB_MiniProgram_Page_Extend.MallBaseId),query.MallBaseId),
            };
            return miniProgram_PageRepository.Exists("Id", list);
        }

        /// <summary>
        /// 批量添加页面到小程序
        /// </summary>
        /// <param name="list"></param>
        /// <returns></returns>
        public bool SetMiniProgram_Page_ByListModule(List<RB_MiniProgram_Page_Extend> list)
        {
            bool flag = false;
            foreach (var item in list)
            {
                var Id = CheckMiniProgram_Page(item);
                item.Id = Id;
                if (item.Id > 0)
                {
                    Dictionary<string, object> fileds = new Dictionary<string, object>()
                    {
                        { nameof(RB_MiniProgram_Page_Extend.Id),item.Id},
                        { nameof(RB_MiniProgram_Page_Extend.MallBaseId),item.MallBaseId},
                        { nameof(RB_MiniProgram_Page_Extend.PageId),item.PageId},
             
                    };
                    flag = miniProgram_PageRepository.Update(fileds, new WhereHelper(nameof(RB_MiniProgram_Page_Extend.Id), item.Id));
                }
                else
                {
                    int NewId = miniProgram_PageRepository.Insert(item);
                    item.Id = NewId;
                    flag = NewId > 0;
                }
            }
            return flag;
        }

        /// <summary>
        /// 批量设置小程序页面标题
        /// </summary>
        /// <param name="list"></param>
        /// <returns></returns>
        public bool SetMiniProgram_PageTitle_ByListModule(List<RB_MiniProgram_Page_Extend> list)
        {
            bool flag = false;
            foreach (var item in list)
            {
                if (item.SelfPageName == null)
                {
                    item.SelfPageName = "";
                }
                if (item.Id > 0)
                {
                    Dictionary<string, object> fileds = new Dictionary<string, object>()
                    {
                        { nameof(RB_MiniProgram_Page_Extend.SelfPageName),item.SelfPageName},
                    };
                    flag = miniProgram_PageRepository.Update(fileds, new WhereHelper(nameof(RB_MiniProgram_Page_Extend.Id), item.Id));
                }
            }
            return flag;
        }


        /// <summary>
        /// 根据小程序页面编号获取小程序页面实体(单个)
        /// </summary>
        /// <param name="PageId"></param>
        /// <returns></returns>
        public RB_MiniProgram_Page_Extend GetMiniprogram_Page_Module(object Id)
        {
            RB_MiniProgram_Page_Extend extModel = miniProgram_PageRepository.GetEntity<RB_MiniProgram_Page_Extend>(Id);
            if (extModel == null)
            {
                extModel = new RB_MiniProgram_Page_Extend();
            }
            return extModel;
        }

        /// <summary>
        /// 根据Id批量删除
        /// </summary>
        /// <param name="Ids"></param>
        /// <returns></returns>
        public bool RemoveBeatchMiniprogram_Page_Module(string Ids)
        {
            return miniProgram_PageRepository.RemoveBeatchMiniprogram_Page_Repository(Ids);
        }

        /// <summary>
        /// 根据条件获取小程序页面列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Miniprogram_PageManage_Extend> GetMiniprogram_Page_ListExtModule(RB_MiniProgram_Page_Extend query)
        {
            var list= miniprogram_PageManageRepository.GetListExtRepository(query);
            if (list == null)
            {
                list = new List<RB_Miniprogram_PageManage_Extend>();
            }
            //DIY页面
            var selfPageList = miniprogram_Page_TemplRepository.GetMiniprogramPageTemplListRepository(new Model.Entity.MarketingCenter.RB_Miniprogram_Page_Templ_Extend()
            {
                 MallBaseId=query.MallBaseId,
            });
            if (selfPageList != null&& selfPageList.Count>0)
            {
                foreach (var item in selfPageList)
                {
                    list.Add(new RB_Miniprogram_PageManage_Extend()
                    {
                        PageId = item.Id,
                        PageName = item.PageName,
                        PageUrl = "/pages/index/index?page_id=" + item.Id,
                        PageType = Common.Enum.MallBase.PageTypeEnum.DiyPage,
                        IsParameter = 0,
                        TipText="",
                        SelfPageName = item.PageName,
                        ParameterValue = "",
                    });
                }
            }
            return list;
        }

        /// <summary>
        /// 根据查询条件获取小程序页面管理列表【管理页面】
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Miniprogram_PageManage_Extend> GetMiniprogram_PageManage_ListModule(RB_Miniprogram_PageManage_Extend query)
        {
            return miniprogram_PageManageRepository.GetListRepository(query);
        }

        /// <summary>
        /// 获取小程序页面管理分页列表【管理页面】
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Miniprogram_PageManage_Extend> GetMiniprogram_PageManage_PageListModule(int pageIndex, int pageSize, out long rowCount, RB_Miniprogram_PageManage_Extend query)
        {
            return miniprogram_PageManageRepository.GetPageListRepository(pageIndex, pageSize, out rowCount, query);
        }

        /// <summary>
        /// 新增修改小程序管理页面【管理页面】
        /// </summary>
        /// <param name="extModel"></param>
        /// <returns></returns>
        public bool SetMiniprogram_PageManage_Module(RB_Miniprogram_PageManage_Extend extModel)
        {
            bool flag = false;
            if (extModel.IsParameter == 0)
            {
                extModel.ParameterValue = "";
                extModel.TipText = "";
            }
            if (extModel.PageId > 0)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    { nameof(RB_Miniprogram_PageManage_Extend.PageType),extModel.PageType},
                    { nameof(RB_Miniprogram_PageManage_Extend.PageName),extModel.PageName.Trim()},
                    { nameof(RB_Miniprogram_PageManage_Extend.PageUrl),extModel.PageUrl.Trim()},
                    { nameof(RB_Miniprogram_PageManage_Extend.PageSort),extModel.PageSort},
                    { nameof(RB_Miniprogram_PageManage_Extend.IsParameter),extModel.IsParameter},
                    { nameof(RB_Miniprogram_PageManage_Extend.ParameterValue),extModel.ParameterValue},
                    { nameof(RB_Miniprogram_PageManage_Extend.TipText),extModel.TipText},

                };
                flag = miniprogram_PageManageRepository.Update(fileds, new WhereHelper(nameof(RB_Miniprogram_PageManage_Extend.PageId), extModel.PageId));
            }
            else
            {
                int NewId = miniprogram_PageManageRepository.Insert(extModel);
                extModel.PageId = NewId;
                flag = NewId > 0;
            }
            return flag;
        }

        /// <summary>
        /// 更新菜单状态【管理页面】
        /// </summary>
        /// <param name="PageId">页面Id</param>
        /// <param name="Status">页面状态(0-正常,1-删除)</param>
        /// <returns></returns>
        public bool RemoveMiniprogram_PageManage_Module(object PageId, int Status)
        {
            bool flag = false;
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                { nameof(RB_Miniprogram_PageManage_Extend.Status),Status},
            };
            flag = miniprogram_PageManageRepository.Update(fileds, new WhereHelper(nameof(RB_Miniprogram_PageManage_Extend.PageId), PageId));
            return flag;
        }

        /// <summary>
        /// 根据页面编号获取页面实体【管理页面】
        /// </summary>
        /// <param name="PageId"></param>
        /// <returns></returns>
        public RB_Miniprogram_PageManage_Extend GetMiniprogram_PageManage_Module(object PageId)
        {
            RB_Miniprogram_PageManage_Extend extModel = miniprogram_PageManageRepository.GetEntity<RB_Miniprogram_PageManage_Extend>(PageId);
            if (extModel == null)
            {
                extModel = new RB_Miniprogram_PageManage_Extend();
            }
            return extModel;
        }
    }
}
