﻿using Mall.Model.Entity.Property;
using Mall.Model.Extend.Property;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Repository.Property
{
    /// <summary>
    /// 耗材仓库仓储类
    /// </summary>
    public partial class RB_Supplies_WareHouseRepository : BaseRepository<RB_Supplies_WareHouse>
    {
        /// <summary>
        /// 获取耗材仓库分页数据
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="dmodel"></param>
        /// <param name="count"></param>
        /// <returns></returns>
        public List<RB_Supplies_WareHouse_Extend> GetPageList(int pageIndex, int pageSize, RB_Supplies_WareHouse_Extend dmodel, out long count)
        {
            string where = " where 1=1 ";
            where += string.Format(" AND {0}={1}", nameof(RB_Supplies_WareHouse_Extend.Status), 0);
            where += $@" and RB_Group_Id={dmodel.RB_Group_Id}";            
            if (!string.IsNullOrWhiteSpace(dmodel.Name.Trim()))
            {
                where += " and " + nameof(RB_Supplies_WareHouse_Extend.Name) + " like '%" + dmodel.Name.Trim() + "%'";
            }
            
            string sql = $@" select * from RB_Supplies_WareHouse {where} order by Id desc";
            return GetPage<RB_Supplies_WareHouse_Extend>(pageIndex, pageSize, out count, sql).ToList();
        }


        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Supplies_WareHouse_Extend> GetList(RB_Supplies_WareHouse_Extend dmodel)
        {
            string where = " where 1=1 ";
            where += string.Format(" AND {0}={1}", nameof(RB_Supplies_WareHouse_Extend.Status), 0);
            where += $@" and RB_Group_Id={dmodel.RB_Group_Id}";
            if (!string.IsNullOrWhiteSpace(dmodel.Name))
            {
                where += " and " + nameof(RB_Supplies_WareHouse_Extend.Name) + " like '%" + dmodel.Name + "%'";
            }
            if (!string.IsNullOrEmpty(dmodel.WareHouseIdStr)) {

                where += $@" and {nameof(RB_Supplies_WareHouse.Id)} in ({dmodel.WareHouseIdStr})";
            }
            string sql = $@" select * from RB_Supplies_WareHouse {where} order by Id desc";
            return Get<RB_Supplies_WareHouse_Extend>(sql).ToList();
        }
    }
}
