﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.User;
using Mall.Model.Extend.User;
using System.Linq;

namespace Mall.Repository.User
{
    /// <summary>
    /// 和平分销商品分类仓储层
    /// </summary>
    public class RB_Distributor_HPCategoryRepository : BaseRepository<RB_Distributor_HPCategory>
    {

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Distributor_HPCategory_Extend> GetList(RB_Distributor_HPCategory_Extend dmodel)
        {
            string where = $@" 1=1 ";
            if (dmodel.TenantId > 0)
            {
                where += $@" and hpc.{nameof(RB_Distributor_HPCategory.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and hpc.{nameof(RB_Distributor_HPCategory.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.CommissionId > 0)
            {
                where += $@" and hpc.{nameof(RB_Distributor_HPCategory.CommissionId)}={dmodel.CommissionId}";
            }
            if (!string.IsNullOrEmpty(dmodel.CommissionIds)) {
                where += $@" and hpc.{nameof(RB_Distributor_HPCategory.CommissionId)} in({dmodel.CommissionIds})";
            }

            string sql = $@"select hpc.*,c.Name as CategoryName from RB_Distributor_HPCategory hpc
inner join RB_Product_Category c on hpc.CategoryId=c.Id
where {where} order by hpc.Id desc";
            return Get<RB_Distributor_HPCategory_Extend>(sql).ToList();
        }
    }
}
