﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Common.Enum;
using Mall.Common.Enum.TradePavilion;
using VT.FW.DB;

namespace Mall.Model.Entity.TradePavilion
{
    /// <summary>
    ///【商载通】  品牌/企业申请实体表
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_BrandEnterpriseApplyFor
    {
        /// <summary>
        /// 编号
        /// </summary>
        public int ID { get; set; }

        /// <summary>
        /// 商户号id
        /// </summary>
        public int TenantId { get; set; }

        /// <summary>
        /// 小程序id
        /// </summary>
        public int MallBaseId { get; set; }
        /// <summary>
        /// 创建人
        /// </summary>
        public int CreateBy { get; set; }

        /// <summary>
        /// 创建时间
        /// </summary>
        public DateTime CreateDate { get; set; }

        /// <summary>
        /// 修改人
        /// </summary>
        public int UpdateBy { get; set; }

        /// <summary>
        /// 修改时间
        /// </summary>
        public DateTime UpdateDate { get; set; }

        /// <summary>
        /// 删除状态
        /// </summary>
        public DateStateEnum Status { get; set; }


        /// <summary>
        /// logo
        /// </summary>
        public string Logo { get; set; }


        /// <summary>
        /// 品牌介绍图
        /// </summary>
        public string Banner { get; set; }

        /// <summary>
        /// 品牌视频
        /// </summary>
        public string VideoUrl { get; set; }
        /// <summary>
        /// 品牌全名
        /// </summary>
        public string FullBrandName { get; set; }


        /// <summary>
        /// 品牌名称
        /// </summary>
        public string BrandName { get; set; }

        /// <summary>
        /// 店铺数量
        /// </summary>
        public int ShopNum { get; set; }

        /// <summary>
        /// 建筑面积
        /// </summary>
        public decimal BuiltUpArea { get; set; }

        /// <summary>
        /// 建筑面积
        /// </summary>
        public decimal EndBuiltUpArea { get; set; }


        /// <summary>
        /// 品牌定位
        /// </summary>
        public string BrandType { get; set; }

        /// <summary>
        /// 客户群体
        /// </summary>
        public string CustomerType { get; set; }




        /// <summary>
        /// 扩店区域
        /// </summary>
        public string StoreExpansion { get; set; }

        /// <summary>
        /// 性质
        /// </summary>
        public ProjectTypeEnum? ProjectType { get; set; }

        /// <summary>
        /// 面积要求
        /// </summary>
        public decimal AreaRequirement { get; set; }

        /// <summary>
        /// 面积要求
        /// </summary>
        public decimal EndAreaRequirement { get; set; }


        /// <summary>
        /// 广告
        /// </summary>
        public string Advertising { get; set; }

        /// <summary>
        /// 其他
        /// </summary>
        public string Other { get; set; }



        /// <summary>
        /// 店铺开口尺寸（0-否1-有）
        /// </summary>
        public int IsShopSize { get; set; }
        /// <summary>
        /// 店铺开口尺寸
        /// </summary>
        public string ShopSize { get; set; }

        /// <summary>
        /// 上下水（0-否1-有）
        /// </summary>
        public int Plumbing { get; set; }

        /// <summary>
        /// 管径（0-否1-有）
        /// </summary>
        public int Caliber { get; set; }
        /// <summary>
        /// 排污（0-否1-有）
        /// </summary>
        public int Sewage { get; set; }

        /// <summary>
        /// 燃气（0-否1-有）
        /// </summary>
        public int RanQi { get; set; }
        /// <summary>
        /// 燃气备注
        /// </summary>
        public string RanQiBZ { get; set; }
        /// <summary>
        /// 电量
        /// </summary>
        public string DianLiang { get; set; }


        /// <summary>
        /// /电量（0-否1-有）
        /// </summary>
        public int IsDianLiang { get; set; }
        /// <summary>
        /// 排烟量（0-否1-有）
        /// </summary>
        public int PaiYan { get; set; }

        /// <summary>
        /// 排烟量
        /// </summary>
        public string PaiYanBZ { get; set; }

        /// <summary>
        /// 空调（0-否1-有）
        /// </summary>
        public int KongTiao { get; set; }

        /// <summary>
        /// 新风（0-否1-有）
        /// </summary>
        public int XinFeng { get; set; }

        /// <summary>
        /// 品牌分类Id
        /// </summary>
        public int BrandClassId { get; set; }


        /// <summary>
        /// 认证id
        /// </summary>
        public int CompanyId { get; set; }

        /// <summary>
        /// 开店意愿（打分）
        /// </summary>
        public decimal OpenShopWish { get; set; }

        /// <summary>
        /// 现有品牌id
        /// </summary>
        public int ExistBrandId { get; set; }

        /// <summary>
        /// 是否已在成都落地 0-否，1-是，-1未填写
        /// </summary>
        public int? IsInChengdu { get; set; }


        /// <summary>
        /// 类型(1-品牌,2-企业服务)
        /// </summary>
        public int BrandEnterpriseType { get; set; }

        /// <summary>
        /// 品牌简介/企业简介
        /// </summary>
        public string Introduce { get; set; }

        /// <summary>
        /// 租赁意向
        /// </summary>
        public string DevIntention { get; set; }

        /// <summary>
        /// 物业需求
        /// </summary>
        public string PropertyDemand { get; set; }

        /// <summary>
        /// 意向合作条件
        /// </summary>
        public string Cooperation { get; set; }

        /// <summary>
        /// 配套需求
        /// </summary>
        public string Complementary { get; set; }

        /// <summary>
        /// 状态0-待审核，1- 审核通过，2-审核失败
        /// </summary>
        public int ApplyForStatus { get; set; }

        /// <summary>
        /// 拒绝备注
        /// </summary>
        public string RejectRemark { get; set; }
    }
}
