﻿using Mall.Model.Entity.TradePavilion;
using System;
using System.Collections.Generic;
using VT.FW.DB;

namespace Mall.Model.Extend.TradePavilion
{
    /// <summary>
    /// 【商载通】楼宇、载体扩展扩展类
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Building_Carrier_Extend : RB_Building_Carrier
    {
        /// <summary>
        /// 分类名称
        /// </summary>
        public string CategoryName { get; set; }

        /// <summary>
        /// 开业开始时间
        /// </summary>
        public string QStartDate { get; set; }

        /// <summary>
        /// 开业结束时间
        /// </summary>
        public string QEndDate { get; set; }

        /// <summary>
        /// 地铁站名称
        /// </summary>
        public string MetroName { get; set; }

        /// <summary>
        /// 地铁线路
        /// </summary>
        public int MetroNum { get; set; }

        /// <summary>
        /// BannerList
        /// </summary>
        public List<string> BannerList { get; set; }

        /// <summary>
        /// 荣誉图片
        /// </summary>
        public List<string> HonorList { get; set; }

        /// <summary>
        /// 地铁信息
        /// </summary>
        public List<RB_Building_Carriermetro_Extend> BuildingCarriermetroList { get; set; }

        /// <summary>
        /// 首店查询类型(1-成都首店,2-宜宾商载通)
        /// </summary>
        public int QShopType { get; set; }
    }
}
