﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Expressions;
using System.Text;
using System.Threading.Tasks;

namespace DapperExtensions.Lambda
{
    /// <summary>
    /// 排序泛型接口
    /// </summary>
    /// <typeparam name="T">约束</typeparam>
    public interface IOrderBy<T> : IOrderBy where T : class
    {
        /// <summary>
        /// 新增排序
        /// </summary>
        /// <param name="lambdaOrderBy">表达式</param>
        void AddOrderBy(Expression<Func<T, object>> lambdaOrderBy);

        /// <summary>
        /// 新增排序
        /// </summary>
        /// <typeparam name="T2">约束</typeparam>
        /// <param name="lambdaOrderBy">表达式</param>
        void AddOrderBy<T2>(Expression<Func<T, T2, object>> lambdaOrderBy);

        /// <summary>
        /// 新增排序
        /// </summary>           
        /// <typeparam name="T2">约束</typeparam>
        /// <typeparam name="T3">约束</typeparam>
        /// <param name="lambdaOrderBy">表达式</param>
        void AddOrderBy<T2, T3>(Expression<Func<T, T2, T3, object>> lambdaOrderBy);

        /// <summary>
        /// 新增排序
        /// </summary>
        /// <typeparam name="T2">约束</typeparam>
        /// <typeparam name="T3">约束</typeparam>
        /// <typeparam name="T4">约束</typeparam>
        /// <param name="lambdaOrderBy">表达式</param>
        void AddOrderBy<T2, T3, T4>(Expression<Func<T, T2, T3, T4, object>> lambdaOrderBy);

        /// <summary>
        /// 新增排序
        /// </summary>
        /// <typeparam name="T2">约束</typeparam>
        /// <typeparam name="T3">约束</typeparam>
        /// <typeparam name="T4">约束</typeparam>
        /// <typeparam name="T5">约束</typeparam>
        /// <param name="lambdaOrderBy">表达式</param>
        void AddOrderBy<T2, T3, T4, T5>(Expression<Func<T, T2, T3, T4, T5, object>> lambdaOrderBy);

        /// <summary>
        /// 新增排序
        /// </summary>
        /// <typeparam name="T2">约束</typeparam>
        /// <typeparam name="T3">约束</typeparam>
        /// <typeparam name="T4">约束</typeparam>
        /// <typeparam name="T5">约束</typeparam>
        /// <typeparam name="T6">约束</typeparam>
        /// <param name="lambdaOrderBy">表达式</param>
        void AddOrderBy<T2, T3, T4, T5, T6>(Expression<Func<T, T2, T3, T4, T5, T6, object>> lambdaOrderBy);


        /// <summary>
        /// 添加倒序
        /// </summary>
        /// <param name="lambdaOrderBy">表达式</param>
        void AddOrderByDescending(Expression<Func<T, object>> lambdaOrderBy);

        /// <summary>
        /// 添加倒序
        /// </summary>
        /// <typeparam name="T2">约束</typeparam>
        /// <param name="lambdaOrderBy">表达式</param>
        void AddOrderByDescending<T2>(Expression<Func<T, T2, object>> lambdaOrderBy);

        /// <summary>
        /// 添加倒序
        /// </summary>
        /// <typeparam name="T2">约束</typeparam>
        /// <typeparam name="T3">约束</typeparam>
        /// <param name="lambdaOrderBy">表达式</param>
        void AddOrderByDescending<T2, T3>(Expression<Func<T, T2, T3, object>> lambdaOrderBy);

        /// <summary>
        /// 添加倒序
        /// </summary>
        /// <typeparam name="T2">约束</typeparam>
        /// <typeparam name="T3">约束</typeparam>
        /// <typeparam name="T4">约束</typeparam>
        /// <param name="lambdaOrderBy">表达式</param>
        void AddOrderByDescending<T2, T3, T4>(Expression<Func<T, T2, T3, T4, object>> lambdaOrderBy);

        /// <summary>
        /// 添加倒序
        /// </summary>
        /// <typeparam name="T2">约束</typeparam>
        /// <typeparam name="T3">约束</typeparam>
        /// <typeparam name="T4">约束</typeparam>
        /// <typeparam name="T5">约束</typeparam>
        /// <param name="lambdaOrderBy">表达式</param>
        void AddOrderByDescending<T2, T3, T4, T5>(Expression<Func<T, T2, T3, T4, T5, object>> lambdaOrderBy);

        /// <summary>
        /// 添加倒序
        /// </summary>
        /// <typeparam name="T2">约束</typeparam>
        /// <typeparam name="T3">约束</typeparam>
        /// <typeparam name="T4">约束</typeparam>
        /// <typeparam name="T5">约束</typeparam>
        /// <typeparam name="T6">约束</typeparam>
        /// <param name="lambdaOrderBy">表达式</param>
        void AddOrderByDescending<T2, T3, T4, T5, T6>(Expression<Func<T, T2, T3, T4, T5, T6, object>> lambdaOrderBy); 
    }


    /// <summary>
    /// 排序接口
    /// </summary>
    public interface IOrderBy  
    {

        /// <summary>
        /// 新增排序
        /// </summary>
        /// <param name="orderby"></param>
        void AddOrderBy(OrderByClip orderby);

        /// <summary>
        /// 新增倒序
        /// </summary>
        /// <param name="orderby"></param>
        void AddOrderByDescending(OrderByClip orderby);

         
        /// <summary>
        /// 转换成WhereClip
        /// </summary>
        /// <returns></returns>
        OrderByClip ToOrderByClip(); 
    }
}
