﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Mall.Common.API;
using Mall.Model.Extend.User;
using Mall.Module.User;
using Mall.WebApi.Filter;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;
using Mall.Common.Plugin;
using Mall.Common.Enum.User;
using Newtonsoft.Json.Linq;
using Mall.Common;
using Mall.Module.Finance;
using Mall.Model.Extend.Finance;

namespace Mall.WebApi.Controllers.Finance
{
    [Route("api/[controller]/[action]")]
    [ApiExceptionFilter]
    [ApiController]
    [EnableCors("AllowCors")]
    public class FinanceController : BaseController
    {
        private readonly FinanceModule financeModule = new FinanceModule();

        #region 财务配置

        /// <summary>
        /// 获取财务配置信息
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetFinanceConfigurationInfo()
        {
            var requestParm = RequestParm;
            var parms = JObject.Parse(requestParm.msg.ToString());
            int Type = parms.GetInt("Type", 0);
            if (Type <= 0)
            {
                return ApiResult.ParamIsNull();
            }

            var obj = financeModule.GetFinanceConfigurationInfo(Type, requestParm.TenantId, requestParm.MallBaseId);
            return ApiResult.Success("", obj);
        }

        /// <summary>
        /// 新增财务配置信息
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult SetFinanceConfigurationInfo() {
            var req = RequestParm;
            RB_Finance_Configurine_Extend demodel = JsonConvert.DeserializeObject<RB_Finance_Configurine_Extend>(req.msg.ToString());
            if (demodel.Type == 1)
            {
                if ((demodel.IsPublic ?? 0) <= 0)
                {
                    return ApiResult.Failed("请传递账户类型");
                }
                if ((demodel.AccountType ?? 0) <= 0)
                {
                    return ApiResult.Failed("请传递账户分类");
                }
                if ((demodel.AccountId ?? 0) <= 0)
                {
                    return ApiResult.Failed("请传递账户id");
                }
                if (string.IsNullOrEmpty(demodel.RemitterName))
                {
                    return ApiResult.Failed("请传递汇款人");
                }
                if ((demodel.IncomeCostTypeId ?? 0) <= 0)
                {
                    return ApiResult.Failed("请传递收款费用类型");
                }
                if ((demodel.FreightCostTypeId ?? 0) <= 0)
                {
                    return ApiResult.Failed("请传递运费收入费用类型");
                }
                if (!demodel.StartTime.HasValue)
                {
                    return ApiResult.Failed("请传递开始时间");
                }
                if ((demodel.IntervalDay ?? 0) <= 0)
                {
                    return ApiResult.Failed("请传递周期");
                }
            }
            else if (demodel.Type == 2)
            {
                if ((demodel.CurrencyId ?? 0) <= 0)
                {
                    return ApiResult.Failed("请选择币种");
                }
                if ((demodel.CBCostTypeId ?? 0) <= 0)
                {
                    return ApiResult.Failed("请选择成本费用类型");
                }
                if ((demodel.ExpensesCostTypeId ?? 0) <= 0) {
                    return ApiResult.Failed("请选择运杂费用类型");
                }
            }
            else if (demodel.Type == 3)
            {
                if ((demodel.CurrencyId ?? 0) <= 0)
                {
                    return ApiResult.Failed("请选择币种");
                }
                if ((demodel.RefundCostTypeId ?? 0) <= 0)
                {
                    return ApiResult.Failed("请选择退款费用类型");
                }
            }
            else if (demodel.Type == 4)
            {
                if ((demodel.CurrencyId ?? 0) <= 0)
                {
                    return ApiResult.Failed("请选择币种");
                }
                if ((demodel.RemitCostTypeId ?? 0) <= 0)
                {
                    return ApiResult.Failed("请选择提现费用类型");
                }
            }
            else {
                return ApiResult.Failed("type不正确");
            }

            if ((demodel.WorkFlowId ?? 0) <= 0) {
                return ApiResult.Failed("请选择使用流程");
            }

            demodel.Status = 0;
            demodel.TenantId = req.TenantId;
            demodel.MallBaseId = req.MallBaseId;
            demodel.CreateDate = DateTime.Now;
            demodel.UpdateDate = DateTime.Now;
            bool flag = financeModule.SetFinanceConfigurationInfo(demodel);
            if (flag)
            {
                return ApiResult.Success();
            }
            else {
                return ApiResult.Failed();
            }
        }

        /// <summary>
        /// 获取配置枚举
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetFinanceConfigurationEnumList()
        {
            var list = EnumHelper.GetEnumList(typeof(Common.Enum.Finance.FinanceConfigurationEnum));
            return ApiResult.Success("", list.Select(x => new
            {
                Name = x.Key,
                Id = Convert.ToInt32(x.Value)
            }));
        }

        /// <summary>
        /// 获取流程列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetFinanceWorkFlowTemplateList() {
            var requestParm = RequestParm;
            var parms = JObject.Parse(requestParm.msg.ToString());
            int TempLateClass = parms.GetInt("TempLateClass", 0);
            if (TempLateClass <= 0)
            {
                return ApiResult.ParamIsNull();
            }
            var List = financeModule.GetFinanceWorkFlowTemplateList(TempLateClass);
            return ApiResult.Success("", List);
        }

        /// <summary>
        /// 获取费用类型
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetFinanceCostTypeList() {
            var requestParm = RequestParm;
            var parms = JObject.Parse(requestParm.msg.ToString());
            int Type = parms.GetInt("Type", 0);//  1收入  2支出
            if (Type <= 0)
            {
                return ApiResult.ParamIsNull();
            }
            var List = financeModule.GetFinanceCostTypeList(Type);
            return ApiResult.Success("", List);
        }

        /// <summary>
        /// 获取币种列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetFinanceCurrencyList() {
            var List = financeModule.GetFinanceCurrencyList();
            return ApiResult.Success("", List);
        }

        /// <summary>
        /// 获取账户类型列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetAccountTypeList()
        {
            var List = financeModule.GetAccountTypeList();
            return ApiResult.Success("", List);
        }

        /// <summary>
        /// 获取账户列表
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetBankAccountList()
        {
            var req = RequestParm; 
             RB_BackAccount_Extend model = JsonConvert.DeserializeObject<RB_BackAccount_Extend>(req.msg.ToString());
            if (model.TypeId == 0)
            {
                return ApiResult.ParamIsNull();
            }
            model.RB_Group_Id = 2;
            var data = financeModule.GetAccountList(model);
            var list = data.Select(x => new
            {
                Id = x.ID,
                x.Alias,
                x.BackNo,
                x.CurrencyId,
                x.CurrencyName,
                x.Rate,
                x.BankType,
                x.TypeName,
                x.AccountTypeName,
                x.Initialbalance,
                RBNInitialbalance = Math.Round(x.Initialbalance.Value * x.Rate.Value, 2, MidpointRounding.AwayFromZero)
            }).ToList();
            return ApiResult.Success("", list);
        }

        #endregion
    }
}