﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mall.Common.Enum;
using Mall.Model.Entity.Education;
using Mall.Model.Extend.Education;
using VT.FW.DB.Dapper;

namespace Mall.Repository.Education
{
    public class RB_Education_ConsultRepository : BaseRepository<RB_Education_Consult>
    {
        /// <summary>
        /// 获取商会活动报名分页列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Education_Consult_Extend> GetCommerceConsultListRepository(RB_Education_Consult_Extend query)
        {
            DynamicParameters parameters = new DynamicParameters();
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT * 
FROM RB_Education_Consult
WHERE 1=1
");
            if (query == null)
            {
                return new List<RB_Education_Consult_Extend>();
            }
            else
            {
                if (query.EnrollState > 0)
                {
                    if (query.EnrollState == 1)
                    {
                        builder.AppendFormat(" AND {0}={1} ", nameof(RB_Education_Consult_Extend.Status), (int)DateStateEnum.Normal);
                    }
                    else if (query.EnrollState == 2)
                    {
                        builder.AppendFormat(" AND {0}={1} ", nameof(RB_Education_Consult_Extend.Status), (int)DateStateEnum.Delete);
                    }
                }
                else
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Education_Consult_Extend.Status), (int)DateStateEnum.Normal);
                }
                if (query.TenantId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Education_Consult_Extend.TenantId), query.TenantId);
                }
                if (query.OrderStatus > -1)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Education_Consult_Extend.OrderStatus), query.OrderStatus);
                }
                if (query.MallBaseId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Education_Consult_Extend.MallBaseId), query.MallBaseId);
                }
                if (!string.IsNullOrEmpty(query.LinkMan))
                {
                    builder.AppendFormat(" AND {0} LIKE @Name ", nameof(RB_Education_Consult_Extend.LinkMan));
                    parameters.Add("Name", "%" + query.LinkMan.Trim() + "%");
                }
                if (query.ActivityId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Education_Consult_Extend.ActivityId), query.ActivityId);
                }
                if (!string.IsNullOrEmpty(query.QActivityIds))
                {
                    builder.AppendFormat(" AND {0} IN({1}) ", nameof(RB_Education_Consult_Extend.ActivityId), query.QActivityIds);
                }
                if (!string.IsNullOrEmpty(query.QUserIds))
                {
                    builder.AppendFormat(" AND {0} IN({1}) ", nameof(RB_Education_Consult_Extend.UserId), query.QUserIds);
                }
                if (query.UserId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Education_Consult_Extend.UserId), query.UserId);
                }
                if (query.Id > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Education_Consult_Extend.Id), query.Id);
                }
            }
            return Get<RB_Education_Consult_Extend>(builder.ToString(), parameters).ToList();
        }

        /// <summary>
        /// 获取用户的报名列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Education_Consult_Extend> GetUserJoinActivityPageList(int pageIndex, int pageSize, out long rowsCount, RB_Education_Consult_Extend query)
        {
            DynamicParameters parameters = new DynamicParameters();
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT c.*,a.ActivityName,a.CoverImg,a.StartTime,a.EndTime,t.TypeName
FROM RB_Education_Consult c
left join rb_education_activity a on c.ActivityId = a.Id
left join rb_education_activitytype t on t.Id = a.ActivityType
WHERE 1=1
");
            if (query == null)
            {
                rowsCount = 0;
                return new List<RB_Education_Consult_Extend>();
            }
            else
            {
                if (query.EnrollState > 0)
                {
                    if (query.EnrollState == 1)
                    {
                        builder.AppendFormat(" AND c.{0}={1} ", nameof(RB_Education_Consult_Extend.Status), (int)DateStateEnum.Normal);
                    }
                    else if (query.EnrollState == 2)
                    {
                        builder.AppendFormat(" AND c.{0}={1} ", nameof(RB_Education_Consult_Extend.Status), (int)DateStateEnum.Delete);
                    }
                }
                else
                {
                    builder.AppendFormat(" AND c.{0}={1} ", nameof(RB_Education_Consult_Extend.Status), (int)DateStateEnum.Normal);
                }

                if (query.OrderStatus > -1)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Education_Consult_Extend.OrderStatus), query.OrderStatus);
                }
                if (query.TenantId > 0)
                {
                    builder.AppendFormat(" AND c.{0}={1} ", nameof(RB_Education_Consult_Extend.TenantId), query.TenantId);
                }
                if (query.MallBaseId > 0)
                {
                    builder.AppendFormat(" AND c.{0}={1} ", nameof(RB_Education_Consult_Extend.MallBaseId), query.MallBaseId);
                }
                if (!string.IsNullOrEmpty(query.LinkMan))
                {
                    builder.AppendFormat(" AND c.{0} LIKE @Name ", nameof(RB_Education_Consult_Extend.LinkMan));
                    parameters.Add("Name", "%" + query.LinkMan.Trim() + "%");
                }
                if (query.ActivityId > 0)
                {
                    builder.AppendFormat(" AND c.{0}={1} ", nameof(RB_Education_Consult_Extend.ActivityId), query.ActivityId);
                }
                if (!string.IsNullOrEmpty(query.QActivityIds))
                {
                    builder.AppendFormat(" AND c.{0} IN({1}) ", nameof(RB_Education_Consult_Extend.ActivityId), query.QActivityIds);
                }
                if (!string.IsNullOrEmpty(query.QUserIds))
                {
                    builder.AppendFormat(" AND c.{0} IN({1}) ", nameof(RB_Education_Consult_Extend.UserId), query.QUserIds);
                }
                if (query.UserId > 0)
                {
                    builder.AppendFormat(" AND c.{0}={1} ", nameof(RB_Education_Consult_Extend.UserId), query.UserId);
                }
            }
            builder.AppendFormat(" order by c.Id desc");
            return GetPage<RB_Education_Consult_Extend>(pageIndex, pageSize, out rowsCount, builder.ToString(), parameters).ToList();
        }

        /// <summary>
        /// 获取活动报名人数
        /// </summary>
        /// <param name="activityId"></param>
        /// <returns></returns>
        public int GetActivityEnrollNum(int activityId, int sex = 0)
        {
            string sql = $@" select count(0) from RB_Education_Consult where Status =0 and OrderStatus=1 and ActivityId ={activityId}";
            if (sex > 0)
            {
                sql += $@" and Sex ={sex}";
            }
            var obj = ExecuteScalar(sql);
            return obj == null ? 0 : Convert.ToInt32(obj);
        }

    }
}
