﻿using Mall.Model.Entity.Product;
using Mall.Model.Extend.Product;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Repository.Product
{
    /// <summary>
    /// 拼团活动商品关联会员价格表仓储层
    /// </summary>
    public class RB_Groupbuy_MemberpriceRepository:BaseRepository<RB_Groupbuy_Memberprice>
    {
        /// <summary>
        /// 获取拼团活动商品分销佣金
        /// </summary>
        /// <returns></returns>
        public List<RB_Groupbuy_Memberprice_Extend> GetGroupBuyMemberpriceRepository(RB_Groupbuy_Memberprice_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append(@" SELECT * FROM RB_Groupbuy_Memberprice WHERE 1=1 ");
            if (query != null)
            {
                if (query.MallBaseId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Groupbuy_Memberprice_Extend.MallBaseId), query.MallBaseId);
                }
                if (query.TenantId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Groupbuy_Memberprice_Extend.TenantId), query.TenantId);
                }
                if (query.GoodsId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Groupbuy_Memberprice_Extend.GoodsId), query.GoodsId);
                }
                if (!string.IsNullOrWhiteSpace(query.GoodIds))
                {
                    builder.AppendFormat(" AND {0} IN({1}) ", nameof(RB_Groupbuy_Memberprice_Extend.GoodsId), query.GoodIds);
                }
            }
            return Get<RB_Groupbuy_Memberprice_Extend>(builder.ToString()).ToList();
        }
    }
}
