﻿using Mall.Common.Plugin;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Common.Enum.Finance
{
    /// <summary>
    /// 客户类型枚举
    /// </summary>
    public enum ClientTypeEnum
    {
        /// <summary>
        ///酒店供应商
        /// </summary>
        [EnumField("酒店供应商")]
        HotelSupplier = 1,
        /// <summary>
        /// 票卷供应商
        /// </summary>
        [EnumField("票卷供应商")]
        TicketSupplier = 2,
        /// <summary>
        /// 餐厅供应商
        /// </summary>
        [EnumField("餐厅供应商")]
        DiningSupplier = 3,
        /// <summary>
        /// 车辆供应商
        /// </summary>
        [EnumField("车辆供应商")]
        CarSupplier = 4,
        /// <summary>
        /// 签证供应商
        /// </summary>
        [EnumField("签证供应商")]
        VisaSupplier = 5,
        /// <summary>
        /// 机票供应商
        /// </summary>
        [EnumField("机票供应商")]
        PlaneTicketSupplier = 6,
        /// <summary>
        /// 领队/导游
        /// </summary>
        [EnumField("领队/导游")]
        Leader = 7,
        /// <summary>
        /// 我的客户
        /// </summary>
        [EnumField("我的客户")]
        MyClient = 8,
        ///// <summary>
        ///// OP
        ///// </summary>
        //[EnumField("OP")]
        //OP = 9,
        /// <summary>
        /// 员工
        /// </summary>
        [EnumField("员工")]
        Employee = 9,
        /// <summary>
        /// 其他
        /// </summary>
        [EnumField("其他")]
        Other = 10,
        ///// <summary>
        ///// 地接供应商
        ///// </summary>
        //[EnumField("地接供应商")]
        //DiJie = 11
    }
}
