﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.User;
using Mall.Model.Extend.User;
using System.Linq;

namespace Mall.Repository.User
{
    /// <summary>
    /// 轮播图表仓储层
    /// </summary>
    public class RB_Mall_NavRepository : RepositoryBase<RB_Mall_Nav>
    {
        /// <summary>
        /// 轮播图分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Mall_Nav_Extend> GetMallNavPageListRepository(int pageIndex, int pageSize, out long rowCount, RB_Mall_Nav_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@" SELECT * FROM RB_Mall_Nav WHERE 1=1 AND Status=0 ");
            if (query.TenantId > 0)
            {
                builder.AppendFormat(" AND {0}={1} ", nameof(RB_Mall_Nav_Extend.TenantId), query.TenantId);
            }
            if (query.MallBaseId > 0)
            {
                builder.AppendFormat(" AND {0}={1} ", nameof(RB_Mall_Nav_Extend.MallBaseId), query.MallBaseId);
            }
            if (query.Id > 0)
            {
                builder.AppendFormat(" AND {0}={1} ", nameof(RB_Mall_Nav_Extend.Id), query.Id);
            }
            if (query.NavName != null && !string.IsNullOrEmpty(query.NavName.Trim()))
            {
                builder.AppendFormat(" AND {0} LIKE '%{1}%' ", nameof(RB_Mall_Nav_Extend.NavName), query.NavName.Trim());
            }
            return GetPage<RB_Mall_Nav_Extend>(pageIndex, pageSize, out rowCount, builder.ToString()).ToList();
        }

        /// <summary>
        /// 获取轮播图列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Mall_Nav_Extend> GetMallNavListRepository(RB_Mall_Nav_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@" SELECT * FROM RB_Mall_Nav WHERE 1=1 AND Status=0 ");
            if (query.TenantId > 0)
            {
                builder.AppendFormat(" AND {0}={1} ", nameof(RB_Mall_Nav_Extend.TenantId), query.TenantId);
            }
            if (query.MallBaseId > 0)
            {
                builder.AppendFormat(" AND {0}={1} ", nameof(RB_Mall_Nav_Extend.MallBaseId), query.MallBaseId);
            }
            if (query.Id > 0)
            {
                builder.AppendFormat(" AND {0}={1} ", nameof(RB_Mall_Nav_Extend.Id), query.Id);
            }
            if (query.NavName != null && !string.IsNullOrEmpty(query.NavName.Trim()))
            {
                builder.AppendFormat(" AND {0} LIKE '%{1}%' ", nameof(RB_Mall_Nav_Extend.NavName), query.NavName.Trim());
            }
            return Get<RB_Mall_Nav_Extend>(builder.ToString()).ToList();
        }
    }
}
