﻿using Newtonsoft.Json.Linq;
using Test.Model;
using System;
using System.Collections.Generic;
using System.IO;
using System.Net;
using System.Text;
using System.Threading;
using System.Text.RegularExpressions;
using Test.DBHelper;

namespace Test.Helper
{
    /// <summary>
    /// 商城帮助类
    /// </summary>
    public class MallHelper
    {
        /// <summary>
        /// 获取数据
        /// </summary>
        public static void GetData()
        {
            string cookie = "__login_route=%2Fadmin%2Fpassport%2Flogin; __login_role=admin; search={'keyword':'','status':' - 1','sort_prop':'','sort_type':'','cats'[],'date_start':null,'date_end':null}; HJ_SESSION_ID=kmmormovvm2u9qh5drkgsbj1ta; _csrf=7a980bb65eabe0ac3d77199092030044b17ae9779de00eaed628c8095ab2fe0ca%3A2%3A%7Bi%3A0%3Bs%3A5%3A%22_csrf%22%3Bi%3A1%3Bs%3A32%3A%22rsnZWVWkZkpfvVhLBXu8sGG3px0Dgcsx%22%3B%7D";
            GetGategoryImgList(cookie);
        }


        /// <summary>
        /// 获取分类
        /// </summary>
        /// <param name="cookie"></param>
        static void GetGategoryImgList(string cookie)
        {
            var CategoryList = GetCategoryList(cookie);
            if (CategoryList != null && CategoryList.Count > 0)
            {
                var index = 1;
                foreach (var item in CategoryList)
                {
                    Console.WriteLine(index+"/"+ CategoryList.Count + item.name + "分类Start");
                    StringBuilder builder = new StringBuilder();
                    builder.AppendFormat(" INSERT INTO rb_material_group(Name,Type,Sort,Recycled,Status,TenantId,MallBaseId,CreateDate,UpdateDate)");
                    builder.AppendFormat(" VALUES('{0}',{1},{2},1,0,1,1,'{3}','{4}');SELECT LAST_INSERT_ID()", item.name, item.type, item.is_recycle, DateTime.Now, DateTime.Now);
                    int parentId = 0;
                    try
                    {
                        var res = MySqlHelper.ExecuteScalar(MySqlHelper.defaultConnection, System.Data.CommandType.Text, builder.ToString(), null);
                        if (res != null && Convert.ToInt32(res) > 0)
                        {
                            Int32.TryParse(res.ToString(), out parentId);
                        }
                    }
                    catch (Exception ex)
                    {

                    }
                    int pageIndex = 0;
                    int pageCount = 1;
                    List<CategoryImg> imgList = new List<CategoryImg>();
                    while (pageIndex <= pageCount)
                    {
                        var tempImgList = GetCategoryImgList(cookie, pageIndex, item.id, out pageCount);
                        Console.WriteLine(pageIndex + "/" + pageCount + item.name + "分类ing");
                        if (tempImgList != null && tempImgList.Count > 0)
                        {
                            foreach (var subItem in tempImgList)
                            {
                                CreateImage(subItem.url);
                                string path = "https://viitto-1301420277.cos.ap-chengdu.myqcloud.com" + GetFileUrl(subItem.url);
                                StringBuilder stringBuilder = new StringBuilder();
                                stringBuilder.AppendFormat("INSERT INTO rb_material_info(Name,Type,GroupId,Path,Image,VideoTime,WithHeight,TenantId,MallBaseId,CreateDate,UpdateDate,Recycled,Status)");
                                stringBuilder.AppendFormat(" VALUES('{0}',{1},{2},'{3}','{4}',0,0,1,1,'{5}','{6}',1,0)", subItem.name, subItem.type, parentId, path, "", DateTime.Now, DateTime.Now);
                                try
                                {
                                    var newResult = MySqlHelper.ExecuteNonQuery(MySqlHelper.defaultConnection, System.Data.CommandType.Text, stringBuilder.ToString(), null);
                                }
                                catch (Exception ex)
                                {

                                }
                            }
                        }
                        pageIndex++;
                        var ranDomNum = new Random().Next(1, 20);
                        Thread.Sleep(1000 * ranDomNum);
                    }
                    index++;
                    Console.WriteLine(index + "/" + CategoryList.Count + item.name + "分类End");
                }
            }
        }

        /// <summary>
        /// 生成图片
        /// </summary>
        /// <param name="url"></param>
        static void CreateImage(string url)
        {
            string tempPath = GetFileUrl(url);
            string path = Environment.CurrentDirectory + tempPath;//下载到的地址+文件名                                                // 设置参数
            HttpWebRequest request = WebRequest.Create(url) as HttpWebRequest;
            //发送请求并获取相应回应数据
            HttpWebResponse response = request.GetResponse() as HttpWebResponse;
            //直到request.GetResponse()程序才开始向目标网页发送Post请求
            Stream responseStream = response.GetResponseStream();
            string newFilePath = path.Substring(0, path.LastIndexOf("/"));
            if (!System.IO.Directory.Exists(newFilePath))//如果不存在就创建file文件夹
            {
                System.IO.Directory.CreateDirectory(newFilePath);
            }
            //创建本地文件写入流
            Stream stream = new FileStream(path, FileMode.Create);
            byte[] bArr = new byte[1024];
            int size = responseStream.Read(bArr, 0, (int)bArr.Length);
            while (size > 0)
            {
                stream.Write(bArr, 0, size);
                size = responseStream.Read(bArr, 0, (int)bArr.Length);
            }
            stream.Close();
            responseStream.Close();
        }

        /// <summary>
        /// 获取Oss文件全路径
        /// </summary>
        /// <param name="path">文件相对路径</param>
        /// <returns></returns>
        public static string GetFileUrl(string path)
        {
            return path.Replace("https://cdnimg.iotweixin.com", "");
        }

        /// <summary>
        /// 获取分类图片
        /// </summary>
        /// <param name="cookie"></param>
        /// <param name="pageIndex"></param>
        /// <param name="Id">分类编号</param>
        /// <param name="pageCount"></param>
        /// <returns></returns>
        static List<CategoryImg> GetCategoryImgList(string cookie, int pageIndex, int Id, out int pageCount)
        {
            pageCount = 0;
            List<CategoryImg> list = new List<CategoryImg>();
            string imgApi = "https://wx.weibaoge.cn/web/index.php?r=common%2Fattachment%2Flist&page={0}&attachment_group_id={1}&type=image&is_recycle=0&keyword=";
            string newImaApi = string.Format(imgApi, pageIndex, Id);
            cookie = "__login_route=%2Fadmin%2Fpassport%2Flogin; __login_role=admin; search={'keyword':'','status':'-1','sort_prop':'','sort_type':'','cats':[],'date_start':null,'date_end':null}; HJ_SESSION_ID=kmmormovvm2u9qh5drkgsbj1ta; _csrf=7a980bb65eabe0ac3d77199092030044b17ae9779de00eaed628c8095ab2fe0ca%3A2%3A%7Bi%3A0%3Bs%3A5%3A%22_csrf%22%3Bi%3A1%3Bs%3A32%3A%22rsnZWVWkZkpfvVhLBXu8sGG3px0Dgcsx%22%3B%7D";
            string jsonData = HttpGet(newImaApi, cookie);
            if (jsonData != null && !string.IsNullOrEmpty(jsonData))
            {
                JObject obj = JObject.Parse(jsonData);
                JObject dataObj = JObject.Parse(obj["data"].ToString());
                list = Newtonsoft.Json.JsonConvert.DeserializeObject<List<CategoryImg>>(dataObj["list"].ToString());

                var pageObj = JObject.Parse(dataObj["pagination"].ToString());
                Int32.TryParse(pageObj["total_count"].ToString(), out pageCount);
            }
            return list;
        }

        /// <summary>
        /// 获取商品分类
        /// </summary>
        /// <param name="cookie"></param>
        /// <returns></returns>
        static List<Category> GetCategoryList(string cookie)
        {
            List<Category> list = new List<Category>();
            string ApiUrl = "https://wx.weibaoge.cn/web/index.php?r=common%2Fattachment%2Fgroup-list&is_recycle=0&type=image";
            string jsonData = HttpGet(ApiUrl, cookie);
            if (jsonData != null && !string.IsNullOrEmpty(jsonData))
            {
                JObject obj = JObject.Parse(jsonData);
                JObject dataObj = JObject.Parse(obj["data"].ToString());
                list = Newtonsoft.Json.JsonConvert.DeserializeObject<List<Category>>(dataObj["list"].ToString());
            }
            return list;
        }

        /// <summary>
        /// Get获取数据
        /// </summary>
        /// <param name="url">url地址</param>
        /// <param name="encode">编码方式</param>
        /// <param name="Source">来源</param>
        /// <returns></returns>
        static string HttpGet(string url, string cookie)
        {
            HttpWebRequest myRequest = (HttpWebRequest)WebRequest.Create(url);
            myRequest.Headers.Add("cookie", cookie);
            myRequest.Method = "GET";
            HttpWebResponse myResponse = (HttpWebResponse)myRequest.GetResponse();
            StreamReader reader = new StreamReader(myResponse.GetResponseStream(), Encoding.UTF8);
            string content = reader.ReadToEnd();
            reader.Close();
            return content;
        }
    }
}
