﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Extend.User;
using Mall.Repository;
using System.Linq;

namespace Mall.Module.User
{
    /// <summary>
    /// 小程序处理类
    /// </summary>
    public class MiniProgramModule
    {
        /// <summary>
        /// 商户仓储层对象
        /// </summary>
        private Mall.Repository.User.RB_MiniProgramRepository programRepository = new Repository.User.RB_MiniProgramRepository();

        /// <summary>
        /// 底部导航仓储层对象
        /// </summary>
        private Repository.User.RB_Miniprogram_BottomnavRepository bottomnavRepository = new Repository.User.RB_Miniprogram_BottomnavRepository();


        /// <summary>
        /// 根据查询条件获取小程序列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_MiniProgram_Extend> GetTenantListModule(RB_MiniProgram_Extend query)
        {
            return programRepository.GetListRepository(query);
        }

        /// <summary>
        /// 获取小程序分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_MiniProgram_Extend> GetMiniProgramPageListModule(int pageIndex, int pageSize, out long rowCount, RB_MiniProgram_Extend query)
        {
            return programRepository.GetPageListRepository(pageIndex, pageSize, out rowCount, query);
        }


        /// <summary>
        /// 判断用户是否存在
        /// </summary>
        /// <param name="extModel"></param>
        /// <returns></returns>
        public bool CheckMiniProgramModule(RB_MiniProgram_Extend extModel)
        {
            List<WhereHelper> wheres = new List<WhereHelper>()
            {
                new WhereHelper(nameof(RB_MiniProgram_Extend.MallName),extModel.MallName.Trim())
            };
            return programRepository.Exists(wheres);
        }

        /// <summary>
        /// 检查小程序数量
        /// </summary>
        /// <param name="TenantId">商户Id</param>
        /// <returns></returns>
        public int CheckMallNumModule(int TenantId)
        {
            return programRepository.CheckMallNumRepository(TenantId);
        }

        /// <summary>
        /// 添加修改小程序
        /// </summary>
        /// <param name="extModel"></param>
        /// <returns></returns>
        public bool SetMiniProgramModule(RB_MiniProgram_Extend extModel)
        {
            bool flag = false;
            if (extModel.IsEffective == 1)
            {
                extModel.MallValidate = null;
            }
            if (extModel.MallBaseId > 0)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    { nameof(RB_MiniProgram_Extend.MallName),extModel.MallName.Trim()},
                    { nameof(RB_MiniProgram_Extend.IsEffective),extModel.IsEffective},
                    { nameof(RB_MiniProgram_Extend.MallValidate),extModel.MallValidate},
                };
                flag = programRepository.Update(fileds, new WhereHelper(nameof(RB_MiniProgram_Extend.MallBaseId), extModel.MallBaseId));
            }
            else
            {
                extModel.MallName = extModel.MallName.Trim();
                extModel.CreateDate = DateTime.Now;
                int NewId = programRepository.Insert(extModel);
                extModel.MallBaseId = NewId;
                if (extModel.BottomTagList != null)
                {
                    SetMiniProgramMallTagModule(extModel, isUpdateBasic: false);
                }
                flag = NewId > 0;
            }
            return flag;
        }

        /// <summary>
        /// 设置顶部和底部导航配置
        /// </summary>
        /// <param name="extModel"></param>
        /// <returns></returns>
        public bool SetMiniProgramMallTagModule(RB_MiniProgram_Extend extModel,bool isUpdateBasic=true)
        {
            bool flag = false;
            if (extModel.MallBaseId > 0)
            {
                if (isUpdateBasic)
                {
                    Dictionary<string, object> fileds = new Dictionary<string, object>()
                    {
                        { nameof(RB_MiniProgram_Extend.TopNavWordType),extModel.TopNavWordType},
                        { nameof(RB_MiniProgram_Extend.TopNavWordColor),extModel.TopNavWordColor},
                        { nameof(RB_MiniProgram_Extend.TopNavBgColor),extModel.TopNavBgColor},
                        { nameof(RB_MiniProgram_Extend.BottomNavBgColor),extModel.BottomNavBgColor},
                        { nameof(RB_MiniProgram_Extend.BottomNavIsShadow),extModel.BottomNavIsShadow},
                    };
                    flag = programRepository.Update(fileds, new WhereHelper(nameof(RB_MiniProgram_Extend.MallBaseId), extModel.MallBaseId));
                }
         
                if (extModel.BottomTagList != null && extModel.BottomTagList.Count > 0)
                {
                    foreach (var item in extModel.BottomTagList)
                    {
                        if (item.TagId > 0)
                        {
                            Dictionary<string, object> tagfileds = new Dictionary<string, object>()
                            {
                                { nameof(RB_Miniprogram_Bottomnav_Extend.DefaultIcon),item.DefaultIcon},
                                { nameof(RB_Miniprogram_Bottomnav_Extend.CheckedIcon),item.CheckedIcon},
                                { nameof(RB_Miniprogram_Bottomnav_Extend.TagName),item.TagName},
                                { nameof(RB_Miniprogram_Bottomnav_Extend.DefaultColor),item.DefaultColor},
                                { nameof(RB_Miniprogram_Bottomnav_Extend.CheckedColor),item.CheckedColor},
                                { nameof(RB_Miniprogram_Bottomnav_Extend.TagLink),item.TagLink},
                            };
                            flag = bottomnavRepository.Update(tagfileds, new WhereHelper(nameof(RB_Miniprogram_Bottomnav_Extend.TagId), item.TagId));
                        }
                        else
                        {
                            item.MallBaseId = extModel.MallBaseId;
                            item.TenantId = extModel.TenantId;
                            item.Status = 0;
                            flag = bottomnavRepository.Insert(item) > 0;
                        }
                    }
                }
            }
            return flag;
        }

        /// <summary>
        /// 修改小程序版权信息
        /// </summary>
        /// <param name="extModel"></param>
        /// <returns></returns>
        public bool SetMiniProgramCopyRightModule(RB_MiniProgram_Extend extModel)
        {
            bool flag = false;
            if (extModel.MallBaseId > 0)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    { nameof(RB_MiniProgram_Extend.CopyRightWord),extModel.CopyRightWord.Trim()},
                    { nameof(RB_MiniProgram_Extend.CopyRightImg),extModel.CopyRightImg},
                    { nameof(RB_MiniProgram_Extend.CopyRightLink),extModel.CopyRightLink},
                };
                flag = programRepository.Update(fileds, new WhereHelper(nameof(RB_MiniProgram_Extend.MallBaseId), extModel.MallBaseId));
            }
            return flag;
        }



        /// <summary>
        /// 根据编号获取小程序信息
        /// </summary>
        /// <param name="MallBaseId">小程序Id</param>
        /// <param name="isGetNav">是否获取顶部底部配置+底部标签导航(0-不获取,1-获取)</param>
        /// <returns></returns>
        public RB_MiniProgram_Extend GetMiniProgramModule(object MallBaseId,int isGetNav=0)
        {
            RB_MiniProgram_Extend extModel = programRepository.GetEntity<RB_MiniProgram_Extend>(MallBaseId);
            if (extModel == null)
            {
                extModel = new RB_MiniProgram_Extend();
            }
            if (isGetNav == 1)
            {
                extModel.BottomTagList = bottomnavRepository.GetListRepository(new RB_Miniprogram_Bottomnav_Extend() { MallBaseId = extModel.MallBaseId });
                if (extModel.BottomTagList != null && extModel.BottomTagList.Count > 0)
                {
                    extModel.BottomTagList.FirstOrDefault().IsActive = true;
                }
            }
            return extModel;
        }

        /// <summary>
        /// 更新小程序状态
        /// </summary>
        /// <param name="MallBaseId">小程序Id</param>
        /// <param name="Status">小程序状态</param>
        /// <returns></returns>
        public bool SetMiniProgramModule(object MallBaseId, int Status)
        {
            bool flag = false;
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                { nameof(RB_MiniProgram_Extend.Status),Status},
            };
            flag = programRepository.Update(fileds, new WhereHelper(nameof(RB_MiniProgram_Extend.MallBaseId), MallBaseId));
            return flag;
        }

        /// <summary>
        /// 修改小程序商城风格信息
        /// </summary>
        /// <param name="extModel"></param>
        /// <returns></returns>
        public bool SetMiniProgramMallShopStyleModule(RB_MiniProgram_Extend extModel)
        {
            bool flag = false;
            if (extModel.MallBaseId > 0)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    { nameof(RB_MiniProgram_Extend.MallShopStyle),extModel.MallShopStyle},
                };
                flag = programRepository.Update(fileds, new WhereHelper(nameof(RB_MiniProgram_Extend.MallBaseId), extModel.MallBaseId));
            }
            return flag;
        }



        /// <summary>
        /// 删除小程序底部导航
        /// </summary>
        /// <param name="TagId"></param>
        /// <returns></returns>
        public bool RemoveMiniProgramMallTagModule(object TagId)
        {
            var flag = false;
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                { nameof(RB_Miniprogram_Bottomnav_Extend.Status),1},
            };
            flag = bottomnavRepository.Update(fileds, new WhereHelper(nameof(RB_Miniprogram_Bottomnav_Extend.TagId), TagId));
            return flag;
        }
    }
}
