﻿using Mall.Model.Entity.MarketingCenter;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Repository.MarketingCenter
{
    public class RB_DiscountCoupon_ProductRepository : RepositoryBase<RB_DiscountCoupon_Product>
    {
        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_DiscountCoupon_Product); } }

        /// <summary>
        /// 优惠券对应的商品/分类列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_DiscountCoupon_Product> GetCouponProductList(RB_DiscountCoupon_Product query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT * FROM {TableName} WHERE {nameof(RB_DiscountCoupon_Product.Status)}=0 ");
            if (query != null)
            {
                if (query.ID > 0)
                {
                    builder.Append($" AND {nameof(RB_DiscountCoupon_Product.ID)}={query.ID}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_DiscountCoupon_Product.TenantId)}={query.TenantId}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_DiscountCoupon_Product.MallBaseId)}={query.MallBaseId}");
                }
                if (query.DiscountCouponId > 0)
                {
                    builder.Append($" AND {nameof(RB_DiscountCoupon_Product.DiscountCouponId)}={query.DiscountCouponId}");
                }
            }
            return Get<RB_DiscountCoupon_Product>(builder.ToString()).ToList();
        }
    }
}
