﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Mall.IM.Service.User
{
    public class UserInfoModel
    {

        /// <summary>
        /// 必填
        /// 用户帐号，最大长度32字符，必须保证一个APP内唯一
        /// </summary>
        public String AccID { get; set; }

        /// <summary>
        /// 用户名 
        /// 网易云通信ID昵称，最大长度64字符，用来PUSH推送时显示的昵称
        /// </summary>
        public String Name { get; set; }

        /// <summary>
        /// 网易云通信ID头像URL，第三方可选填，最大长度1024
        /// </summary>
        public String Icon { get; set; }

        /// <summary>
        /// 用户签名，最大长度256字符
        /// </summary>
        public String Sign { get; set; }
        /// <summary>
        /// 用户email，最大长度64字符
        /// </summary>
        public String Email { get; set; }
        /// <summary>
        /// 用户生日，最大长度16字符
        /// </summary>
        public String Birth { get; set; }
        /// <summary>
        /// 用户mobile，最大长度32字符   
        /// </summary>
        public String Mobile { get; set; }
        /// <summary>
        /// 用户性别，0表示未知，1表示男，2女表示女，其它会报参数错误 
        /// </summary>
        public int Gender { get; set; }
        /// <summary>
        /// 用户名片扩展字段，最大长度1024字符，用户可自行扩展，建议封装成JSON字符串
        /// </summary>
        public String Ex { get; set; }
    }
}
