﻿using Mall.Model.Extend.TradePavilion;
using Mall.Repository.TradePavilion;
using System.Collections.Generic;
using VT.FW.DB;

namespace Mall.Module.TradePavilion
{
    /// <summary>
    /// 公司信息处理类
    /// </summary>
    public class CompanyModule
    {
        private readonly RB_CompanyRepository companyRepository = new RB_CompanyRepository();

        /// <summary>
        /// 获取公司信息分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Company_Extend> GetCompanyPageListModule(int pageIndex, int pageSize, out long rowsCount, RB_Company_Extend query)
        {
            return companyRepository.GetCompanyPageListRepository(pageIndex, pageSize, out rowsCount, query);
        }

        /// <summary>
        /// 获取公司信息实体
        /// </summary>
        /// <param name="CompanyId"></param>
        /// <returns></returns>
        public RB_Company_Extend GetCompanyModule(object CompanyId)
        {
            return companyRepository.GetEntity<RB_Company_Extend>(CompanyId);
        }

        /// <summary>
        /// 新增修改公司信息
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool SetCompanyModule(RB_Company_Extend model)
        {
            bool flag;
            if (model.CompanyId > 0)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    {nameof(RB_Company_Extend.CompanyName),model.CompanyName },
                    {nameof(RB_Company_Extend.CompanyEnName),model.CompanyEnName },
                    {nameof(RB_Company_Extend.Principal),model.Principal },
                    {nameof(RB_Company_Extend.Mobile),model.Mobile },
                    {nameof(RB_Company_Extend.EMail),model.EMail },
                    {nameof(RB_Company_Extend.LegalPerson),model.LegalPerson },
                    {nameof(RB_Company_Extend.WechatNo),model.WechatNo },
                    {nameof(RB_Company_Extend.CompanyIntro),model.CompanyIntro },
                    {nameof(RB_Company_Extend.DomainUrl),model.DomainUrl },
                    {nameof(RB_Company_Extend.FoundingTime),model.FoundingTime },
                    {nameof(RB_Company_Extend.EmployeeNum),model.EmployeeNum },
                    {nameof(RB_Company_Extend.AnnualSales),model.AnnualSales },
                    {nameof(RB_Company_Extend.AnnualImport),model.AnnualImport },
                    {nameof(RB_Company_Extend.Address),model.Address },
                    {nameof(RB_Company_Extend.EnAddress),model.EnAddress },
                    {nameof(RB_Company_Extend.Industry),model.Industry },
                    {nameof(RB_Company_Extend.ExportCountry),model.ExportCountry },
                    {nameof(RB_Company_Extend.ImportCountry),model.ImportCountry },
                    {nameof(RB_Company_Extend.ImportCategory),model.ImportCategory },
                    {nameof(RB_Company_Extend.OtherInfo),model.OtherInfo },
                    {nameof(RB_Company_Extend.UpdateBy),model.UpdateBy },
                    {nameof(RB_Company_Extend.UpdateDate),model.UpdateDate },
                };
                flag = companyRepository.Update(fileds, new WhereHelper(nameof(RB_Company_Extend.CompanyId), model.CompanyId));
            }
            else
            {
                var newId = companyRepository.Insert(model);
                model.CompanyId = newId;
                flag = newId > 0;
            }
            return flag;
        }

        /// <summary>
        /// 更新公司信息状态
        /// </summary>
        /// <param name="CompanyId"></param>
        /// <param name="Status"></param>
        /// <returns></returns>
        public bool RemoveCompanyModule(int CompanyId, int Status)
        {
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                {nameof(RB_Company_Extend.Status),Status },
            };
            bool flag = companyRepository.Update(fileds, new WhereHelper(nameof(RB_Company_Extend.CompanyId), CompanyId));
            return flag;
        }
    }
}
