﻿using Mall.Common.Enum;
using Mall.Model.Extend.MarketingCenter;
using Mall.Repository.MarketingCenter;
using System;
using System.Collections.Generic;
using System.Text;
using VT.FW.DB;
using System.Linq;

namespace Mall.Module.MarketingCenter
{
    /// <summary>
    /// 分享处理类
    /// </summary>
    public class ShareModule
    {
        /// <summary>
        /// 分享分类仓储层对象
        /// </summary>
        private readonly RB_Share_CategoryRepository share_CategoryRepository = new RB_Share_CategoryRepository();

        /// <summary>
        /// 分享详情实体仓储层对象
        /// </summary>
        private readonly RB_Share_FriendRepository share_FriendRepository = new RB_Share_FriendRepository();

        /// <summary>
        /// 获取分享分类分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowsCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Share_Category_Extend> GetShareCategoryPageListModule(int pageIndex, int pageSize, out long rowsCount, RB_Share_Category_Extend query)
        {
            return share_CategoryRepository.GetShareCategoryPageListRepository(pageIndex, pageSize, out rowsCount, query);
        }


        /// <summary>
        /// 获取分享分类列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<object> GetShareCategoryListModule(RB_Share_Category_Extend query)
        {
            List<object> resultList = new List<object>();
            var list = share_CategoryRepository.GetShareCategoryListRepository(query);
            if (list != null)
            {
                var leavelList = list.GroupBy(qitem => new { qitem.Level }).OrderBy(qitem => qitem.Key.Level);
                foreach (var item in list.Where(qitem => qitem.Level == 1))
                {
                    List<object> secondList = new List<object>();
                    var subList = list.Where(qitem => qitem.Level == 2 && qitem.ParentId == item.Id).ToList();
                    foreach (var subItem in subList)
                    {
                        var subModel = new
                        {
                            subItem.Id,
                            subItem.Level,
                            subItem.Name,
                            subItem.ParentId,
                            hasChildren = list.Where(qitem => qitem.Level == 3 && qitem.ParentId == subItem.Id)?.Count() > 0,
                            children = list.Where(qitem => qitem.Level == 3 && qitem.ParentId == subItem.Id).Select(qitem => new { qitem.Id, qitem.Name, qitem.Level, qitem.ParentId })
                        };
                        secondList.Add(subModel);
                    }

                    var rootModel = new
                    {
                        item.Id,
                        item.Level,
                        item.Name,
                        item.ParentId,
                        hasChildren = secondList?.Count>0,
                        children = secondList
                    };
                    resultList.Add(rootModel);
                }
            }
            return resultList;
        }

        /// <summary>
        /// 获取分享详情分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowsCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Share_Friend_Extend> GetShareFriendPageListModule(int pageIndex, int pageSize, out long rowsCount, RB_Share_Friend_Extend query)
        {
            return share_FriendRepository.GetShareFriendPageListRepository(pageIndex, pageSize, out rowsCount, query);
        }


        /// <summary>
        /// 获取分享详情列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Share_Friend_Extend> GetShareFriendListModule(RB_Share_Friend_Extend query)
        {
            return share_FriendRepository.GetShareFriendListRepository(query);
        }

        /// <summary>
        /// 新增修改分类
        /// </summary>
        /// <param name="extModel"></param>
        /// <returns></returns>
        public bool SetShareCategoryModule(RB_Share_Category_Extend extModel)
        {
            bool flag = false;
            if (extModel.Id > 0)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    {nameof(RB_Share_Category_Extend.Name),extModel.Name },
                    {nameof(RB_Share_Category_Extend.Level),extModel.Level },
                    {nameof(RB_Share_Category_Extend.ParentId),extModel.ParentId },
                    {nameof(RB_Share_Category_Extend.UpdateDate),extModel.UpdateDate },
                };
                flag = share_CategoryRepository.Update(fileds, new WhereHelper(nameof(RB_Share_Category_Extend.Id), extModel.Id));
            }
            else
            {
                var newId = share_CategoryRepository.Insert(extModel);
                extModel.Id = newId;
                flag = newId > 0;
            }
            return flag;
        }

        /// <summary>
        /// 删除分享分类
        /// </summary>
        /// <param name="Id"></param>
        /// <returns></returns>
        public bool RemoveShareCategoryModule(object Id)
        {
            bool flag = false;
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                {nameof(RB_Share_Category_Extend.Status),(int) DateStateEnum.Delete},
            };
            flag = share_CategoryRepository.Update(fileds, new WhereHelper(nameof(RB_Share_Category_Extend.Id), Id));
            return flag;
        }

        /// <summary>
        /// 获取分享分类实体
        /// </summary>
        /// <param name="Id"></param>
        /// <returns></returns>
        public RB_Share_Category_Extend GetShareCategoryModule(object Id)
        {
            return share_CategoryRepository.GetEntity<RB_Share_Category_Extend>(Id);
        }

        /// <summary>
        /// 新增修改分享详情
        /// </summary>
        /// <param name="extModel"></param>
        /// <returns></returns>
        public bool SetShareFriendModule(RB_Share_Friend_Extend extModel)
        {
            bool flag = false;
            if (extModel.Id > 0)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    {nameof(RB_Share_Friend_Extend.CateId),extModel.CateId },
                    {nameof(RB_Share_Friend_Extend.GoodsId),extModel.GoodsId },
                    {nameof(RB_Share_Friend_Extend.CoverImg),extModel.CoverImg },
                    {nameof(RB_Share_Friend_Extend.MaterialImg),extModel.MaterialImg },
                    {nameof(RB_Share_Friend_Extend.MaterialInfo),extModel.MaterialInfo },
                    {nameof(RB_Share_Friend_Extend.LinkUrl),extModel.LinkUrl },
                    {nameof(RB_Share_Friend_Extend.IsTop),extModel.IsTop },
                    {nameof(RB_Share_Friend_Extend.SortNum),extModel.SortNum },
                    {nameof(RB_Share_Friend_Extend.UpdateBy),extModel.UpdateBy },
                    {nameof(RB_Share_Friend_Extend.UpdateDate),extModel.UpdateDate },
                };
                flag = share_FriendRepository.Update(fileds, new WhereHelper(nameof(RB_Share_Friend_Extend.Id), extModel.Id));
            }
            else
            {
                var newId = share_FriendRepository.Insert(extModel);
                extModel.Id = newId;
                flag = newId > 0;
            }
            return flag;
        }

        /// <summary>
        /// 获取分享详情实体
        /// </summary>
        /// <param name="Id"></param>
        /// <returns></returns>
        public RB_Share_Friend_Extend GetShareFriendModule(object Id)
        {
            return share_FriendRepository.GetEntity<RB_Share_Friend_Extend>(Id);
        }

        /// <summary>
        /// 根据编号删除分享详情
        /// </summary>
        /// <param name="Id"></param>
        /// <returns></returns>
        public bool RemoveShareFriendModule(object Id)
        {
            bool flag = false;
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                {nameof(RB_Share_Friend_Extend.Status),(int) DateStateEnum.Delete},
            };
            flag = share_FriendRepository.Update(fileds, new WhereHelper(nameof(RB_Share_Friend_Extend.Id), Id));
            return flag;
        }
    }
}
