﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.User;
using Mall.Model.Extend.User;
using System.Linq;

namespace Mall.Repository.User
{
    /// <summary>
    /// 用户会员购买仓储层
    /// </summary>
    public class RB_Member_BuyRepository : RepositoryBase<RB_Member_Buy>
    {
        /// <summary>
        /// 分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="dmodel">查询条件</param>
        /// <returns></returns>
        public List<RB_Member_Buy_Extend> GetPageList(int pageIndex, int pageSize, out long rowCount, RB_Member_Buy_Extend dmodel)
        {
            string where = " 1=1 ";
            if (dmodel.TenantId > 0)
            {
                where += $@" and b.{nameof(RB_Member_Buy_Extend.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and b.{nameof(RB_Member_Buy_Extend.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.Id > 0)
            {
                where += $@" and b.{nameof(RB_Member_Buy_Extend.Id)}={dmodel.Id}";
            }
            if (dmodel.UserId > 0)
            {
                where += $@" and b.{nameof(RB_Member_Buy_Extend.UserId)}={dmodel.UserId}";
            }
            if (!string.IsNullOrEmpty(dmodel.UserName)) 
            {
                where += $@" and u.{nameof(RB_Member_User.Name)} like '%{dmodel.UserName}%'";
            }
            if (!string.IsNullOrEmpty(dmodel.StartTime)) {
                where += $@" and b.{nameof(RB_Member_Buy_Extend.PayTime)} >= '{dmodel.StartTime}'";
            }
            if (!string.IsNullOrEmpty(dmodel.EndTime))
            {
                where += $@" and b.{nameof(RB_Member_Buy_Extend.PayTime)} <= '{dmodel.EndTime} 23:59:59'";
            }

            string sql = $@"select b.*,u.Name as UserName from RB_Member_Buy b
inner join rb_member_user u on b.UserId= u.Id
where {where} order by b.Id desc";
            return GetPage<RB_Member_Buy_Extend>(pageIndex, pageSize, out rowCount, sql).ToList();
        }

    }
}
