﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Common.Enum.MiAi;
using VT.FW.DB;

namespace Mall.Model.Entity.Miai
{
    /// <summary>
    /// 相亲会员基础资料
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_MiAi_BaseInfo
    {
        /// <summary>
        /// 编号
        /// </summary>        
        public int Id
        {
            get;
            set;
        }
        /// <summary>
        /// 会员id
        /// </summary>
        public int UserId { get; set; }


        /// <summary>
        /// 性别1-男，2-女
        /// </summary>
        public int Sex { get; set; }

        /// <summary>
        /// 生日
        /// </summary>
        public string Birthday { get; set; }

        /// <summary>
        /// 体重
        /// </summary>
        public decimal Weight { get; set; }


        /// <summary>
        /// 身高
        /// </summary>
        public decimal Height { get; set; }


        /// <summary>
        /// 学历
        /// </summary>
        public EducationTypeEnum? EducationType { get; set; }

        /// <summary>
        /// 婚姻
        /// </summary>
        public MarriageEnum? Marriage { get; set; }


        /// <summary>
        /// 名称
        /// </summary>
        public string RealName { get; set; }

        /// <summary>
        /// 身份证号
        /// </summary>
        public string IDCardNo { get; set; }

        /// <summary>
        /// 身份证号
        /// </summary>
        public string IDCard { get; set; }

        /// <summary>
        /// 身份证反面
        /// </summary>
        public string IDCardBack { get; set; }


        /// <summary>
        /// 商户号Id
        /// </summary>        
        public int? TenantId
        {
            get;
            set;
        }

        /// <summary>
        /// 小程序Id
        /// </summary>        
        public int? MallBaseId
        {
            get;
            set;
        }


        /// <summary>
        /// 创建时间
        /// </summary>        
        public DateTime? CreateDate
        {
            get;
            set;
        }

        /// <summary>
        /// 删除状态
        /// </summary>        
        public int? Status
        {
            get;
            set;
        }
    }
}
