﻿using Mall.Common.AOP;
using Mall.Common.Enum.User;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.User
{
    /// <summary>
    /// 用户收货地址表实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Member_ShippingAddress
    {

        /// <summary>
        /// Id
        /// </summary>        
        public int Id
        {
            get;
            set;
        }
        /// <summary>
        /// 用户id
        /// </summary>        
        public int? UserId
        {
            get;
            set;
        }
        /// <summary>
        /// 收货人名称
        /// </summary>        
        public string Name
        {
            get;
            set;
        }
        /// <summary>
        /// 联系电话
        /// </summary>        
        public string Mobile
        {
            get;
            set;
        }
        /// <summary>
        /// 国家
        /// </summary>        
        public int? Country
        {
            get;
            set;
        }
        /// <summary>
        /// 省
        /// </summary>        
        public int? Province
        {
            get;
            set;
        }
        /// <summary>
        /// 市
        /// </summary>        
        public int? City
        {
            get;
            set;
        }
        /// <summary>
        /// 区
        /// </summary>        
        public int? District
        {
            get;
            set;
        }
        /// <summary>
        /// 详细地址
        /// </summary>        
        public string Address
        {
            get;
            set;
        }
        /// <summary>
        /// 邮编
        /// </summary>        
        public string PostCode
        {
            get;
            set;
        }
        /// <summary>
        /// 经纬度  英文逗号分隔
        /// </summary>        
        public string Lonlat
        {
            get;
            set;
        }
        /// <summary>
        /// 是否默认  1是  2否
        /// </summary>        
        public int? IsDefault
        {
            get;
            set;
        }
        /// <summary>
        /// 删除状态
        /// </summary>        
        public int? Status
        {
            get;
            set;
        }
        /// <summary>
        /// 商户号
        /// </summary>        
        public int TenantId
        {
            get;
            set;
        }
        /// <summary>
        /// 小程序id
        /// </summary>        
        public int MallBaseId
        {
            get;
            set;
        }
        /// <summary>
        /// CreateDate
        /// </summary>        
        public DateTime? CreateDate
        {
            get;
            set;
        }
        /// <summary>
        /// UpdateDate
        /// </summary>        
        public DateTime? UpdateDate
        {
            get;
            set;
        }
    }
}
