﻿using Mall.Common.AOP;
using Mall.Common.Enum.MallBase;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.BaseSetUp
{
    /// <summary>
    /// 物流设置
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Logistics
    {
        /// <summary>
        /// 编号
        /// </summary>
        public int ID { get; set; }
        /// <summary>
        ///查询类型选择 1-快递鸟，2-阿里云接口
        /// </summary>
        public LogisticsTypeEnum LogisticsType { get; set; }

        /// <summary>
        /// 阿里云APPCODE
        /// </summary>
        public string AliyunAppCode { get; set; }
        /// <summary>
        /// 快递鸟用户ID
        /// </summary>
        public string ExpressBirdID { get; set; }
        /// <summary>
        /// 快递鸟API KEY
        /// </summary>
        public string ExpressBirdAPIKey { get; set; }

        /// <summary>
        /// 商户id
        /// </summary>
        public int TenantId { get; set; }

        /// <summary>
        /// 小程序id
        /// </summary>
        public int MallBaseId { get; set; }
    }
}
