﻿using Mall.Common.AOP;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.Property
{
    /// <summary>
    /// erp员工实体 Entity
    /// </summary> 
    [Serializable]
    [DB(ConnectionName = "UserConnection")]
    public class RB_Employee
    {
        /// <summary>
        /// 主键:员工编号
        /// </summary>        
        public int EmployeeId
        {
            get;
            set;
        }
        /// <summary>
        /// 员工姓名
        /// </summary>    
        public string EmName
        {
            get;
            set;
        }
        /// <summary>
        /// 性别
        /// </summary> 
        public int EmSex
        {
            get;
            set;
        }
        /// <summary>
        /// 身份证号码
        /// </summary>  
        public string EmCard
        {
            get;
            set;
        }
        /// <summary>
        /// 生日
        /// </summary>     
        public DateTime? EmBirthday
        {
            get;
            set;
        }
        /// <summary>
        /// 学历
        /// </summary>   
        public string EmEducation
        {
            get;
            set;
        }
        /// <summary>
        /// 入职时间
        /// </summary>       
        public DateTime? EmEntry
        {
            get;
            set;
        }
        /// <summary>
        /// 离职时间
        /// </summary>        
        public DateTime? EmLeave
        {
            get;
            set;
        }
        /// <summary>
        /// 地址
        /// </summary>   
        public string EmAddress
        {
            get;
            set;
        }
        /// <summary>
        /// 手机号码
        /// </summary>     
        public string EmMobile
        {
            get;
            set;
        }
        /// <summary>
        /// 联系电话
        /// </summary>
        public string EmTel
        {
            get;
            set;
        }
        /// <summary>
        /// QQ号码
        /// </summary>     
        public string EmQQ
        {
            get;
            set;
        }
        /// <summary>
        /// 头像
        /// </summary>        
        public string EmPhoto
        {
            get;
            set;
        }
        /// <summary>
        /// 账号
        /// </summary>        
        //[RegularValidate("^1[34578]\\d{9}$", showMessage = "帐号必须为手机号")]
        public string EmAccount
        {
            get;
            set;
        }
        /// <summary>
        /// 密码
        /// </summary>  
        public string EmPassword
        {
            get;
            set;
        }
        /// <summary>
        /// 集团编号
        /// </summary>        
        public int RB_Group_id
        {
            get;
            set;
        }
        /// <summary>
        /// 分公司编号
        /// </summary>        
        public int RB_Branch_id
        {
            get;
            set;
        }
        /// <summary>
        /// 部门编号
        /// </summary>        
        public int RB_Department_Id
        {
            get;
            set;
        }
        /// <summary>
        /// 职务编号
        /// </summary>        
        public int RB_Post_Id
        {
            get;
            set;
        }
        /// <summary>
        /// 创建时间
        /// </summary>        
        public DateTime? CreateTime
        {
            get;
            set;
        }
        /// <summary>
        /// 创建人
        /// </summary>        
        public int? CreateBy
        {
            get;
            set;
        }
        /// <summary>
        /// 更新时间
        /// </summary>        
        public DateTime? UpdateTime
        {
            get;
            set;
        }
        /// <summary>
        /// 更新人
        /// </summary>        
        public int? UpdateBy
        {
            get;
            set;
        }
        /// <summary>
        /// 密钥
        /// </summary>    
        public string SecretKey
        {
            get;
            set;
        }
        /// <summary>
        /// 是否离职，0:否，1是
        /// </summary>        
        public int? IsLeave
        {
            get;
            set;
        }

        /// <summary>
        /// 用户登陆手机号
        /// </summary>        
        public string EmLoginMobile
        {
            get;
            set;
        }
        /// <summary>
        /// 年假剩余天数
        /// </summary>
        public double? AnnualLeaveDay { get; set; }

        /// <summary>
        /// 是否管理员  1是  2否
        /// </summary>
        public int? IsAdmin { get; set; }

        /// <summary>
        /// 员工类型 0:正式员工,1:临时员工（外聘导游）
        /// </summary>
        public int? EmployeeType { get; set; }

        /// <summary>
        /// 财务催审次数
        /// </summary>
        public int? FinancePushOnNum { get; set; }

        /// <summary>
        /// 是否发送工作日志  1是  0否
        /// </summary>
        public int SendWorkLog { get; set; }

        /// <summary>
        /// 年会备注
        /// </summary>
        public string AnnualLeaveRemark { get; set; }
    }
}
