﻿using Mall.Common.AOP;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.Property
{

    /// <summary>
    /// 商品出库申请实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "PropertyConnection")]
    public class RB_WarehouseOut_Goods
    {

        /// <summary>
        /// 申请id
        /// </summary>
        public int ApplyId { get; set; }


        /// <summary>
        /// Id
        /// </summary>        
        public int ID
        {
            get;
            set;
        }
        /// <summary>
        /// OrderId
        /// </summary>        
        public int OrderId
        {
            get;
            set;
        }

        /// <summary>
        /// 商品id
        /// </summary>        
        public int GoodsId
        {
            get;
            set;
        }

        /// <summary>
        /// 删除状态0-否，1-是
        /// </summary>        
        public int Status
        {
            get;
            set;
        }


        /// <summary>
        /// 出库状态  0-未出库，1-已出库
        /// </summary>
        public int IsOut { get; set; }

        /// <summary>
        /// 订单商品id
        /// </summary>        
        public int OrderGoodsId
        {
            get;
            set;
        }
        /// <summary>
        /// 订单号
        /// </summary>        
        public string OrderNo
        {
            get;
            set;
        }
        /// <summary>
        /// 商品名称
        /// </summary>        
        public string GoodsName
        {
            get;
            set;
        }

        /// <summary>
        /// 规格
        /// </summary>        
        public string Specification
        {
            get;
            set;
        }
        /// <summary>
        /// 规格key
        /// </summary>
        public string SpecificationSort { get; set; }

        /// <summary>
        /// 货号
        /// </summary>        
        public string ProductCode
        {
            get;
            set;
        }

        /// <summary>
        /// 数量
        /// </summary>        
        public int? Number
        {
            get;
            set;
        }

        /// <summary>
        /// 商户号
        /// </summary>        
        public int TenantId
        {
            get;
            set;
        }
        /// <summary>
        /// 小程序id
        /// </summary>        
        public int MallBaseId
        {
            get;
            set;
        }

        

        /// <summary>
        /// 成本价
        /// </summary>
        public decimal? CostMoney { get; set; }
    }
}
