﻿using Mall.Model.Extend.User;
using Mall.Repository;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Module.User
{
    /// <summary>
    /// 商户表处理层
    /// </summary>
    public class TenantModule
    {
        /// <summary>
        /// 商户仓储层对象
        /// </summary>
        private Mall.Repository.User.RB_TenantRepository tenantRepository = new Repository.User.RB_TenantRepository();


        /// <summary>
        /// 根据查询条件获取商户列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Tenant_Extend> GetTenantListModule(RB_Tenant_Extend query)
        {
            return tenantRepository.GetListRepository(query);
        }

        /// <summary>
        /// 获取商户根也列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Tenant_Extend> GetTenantPageListModule(int pageIndex, int pageSize, out long rowCount, RB_Tenant_Extend query)
        {
            return tenantRepository.GetPageListRepository(pageIndex, pageSize, out rowCount, query);
        }

        /// <summary>
        /// 新增修改商户信息
        /// </summary>
        /// <param name="extModel"></param>
        /// <returns></returns>
        public bool SetTenantModule(RB_Tenant_Extend extModel)
        {
            bool flag = false;
            if (extModel.TenantId > 0)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    { nameof(RB_Tenant_Extend.MallName),extModel.MallName},
                };
                flag = tenantRepository.Update(fileds, new WhereHelper(nameof(RB_Tenant_Extend.TenantId), extModel.TenantId));
            }
            else
            {
                int NewId = tenantRepository.Insert(extModel);
                extModel.TenantId = NewId;
                flag = NewId > 0;
            }
            return flag;
        }


        /// <summary>
        /// 根据编号获取商户信息
        /// </summary>
        /// <param name="TenantId">商户号</param>
        /// <returns></returns>
        public RB_Tenant_Extend GetTenantModule(object TenantId)
        {
            RB_Tenant_Extend extModel = tenantRepository.GetEntity<RB_Tenant_Extend>(TenantId);
            if (extModel == null)
            {
                extModel = new RB_Tenant_Extend();
            }
            return extModel;
        }

        /// <summary>
        /// 更新账户张婷
        /// </summary>
        /// <param name="TenantId">商户号</param>
        /// <param name="AccountStatus">账户状态</param>
        /// <returns></returns>
        public bool SetTenantStatusModule(object TenantId, int AccountStatus)
        {
            bool flag = false;
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                { nameof(RB_Tenant_Extend.AccountStatus),AccountStatus},
            };
            flag = tenantRepository.Update(fileds, new WhereHelper(nameof(RB_Tenant_Extend.TenantId), TenantId));
            return flag;
        }
    }
}
