﻿
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Mall.Common.Pay.WeChatPat
{
    /// <summary>
    /// 支付参数实体
    /// </summary>
    public class PayParam : WeChatParam
    {
        /// <summary>
        /// 订单号
        /// </summary>
        public string OrderNumber { get; set; }

        /// <summary>
        /// 退款订单号
        /// </summary>
        public string RefundNumber { get; set; }

        /// <summary>
        /// 金额（分）
        /// </summary>
        public int? TotalFee { get; set; }

        /// <summary>
        /// 退款金额
        /// </summary>
        public int? RefundFee { get; set; }

        /// <summary>
        /// 过期时间，格式（20141010121314）
        /// </summary>
        public string TimeExpire { get; set; }

        /// <summary>
        /// 商品名称
        /// </summary>
        public string ProductName { get; set; }

        /// <summary>
        /// 支付成功回调地址
        /// </summary>
        public string NotifyUrl { get; set; }

        /// <summary>
        /// 支付方式
        /// </summary>
        public TradeType? TradeType { get; set; }

        /// <summary>
        /// 是否充值订单
        /// </summary>
        public bool IsRecharge { get; set; }


        /// <summary>
        /// 小程序id
        /// </summary>
        public int MallBaseId { get; set; }



        /// <summary>
        /// 商户ID
        /// </summary>
        public int TenantId { get; set; }
    }


    /// <summary>
    /// 支付方式
    /// </summary>
    public enum TradeType
    {
        /// <summary>
        /// JSAPI
        /// </summary>
        JSAPI,
        /// <summary>
        /// NATIVE
        /// </summary>
        NATIVE,
        /// <summary>
        /// APP
        /// </summary>
        APP
    }
}
