﻿using Mall.Common.AOP;
using Mall.Common.Enum.MarketingCenter;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.MarketingCenter
{
    /// <summary>
    /// 模板市场实体类
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Template_Market
    {
        /// <summary>
        /// 主键编号
        /// </summary>        
        public int Id
        {
            get;
            set;
        }

        /// <summary>
        /// 名称
        /// </summary>        
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// 图片
        /// </summary>        
        public string Pics
        {
            get;
            set;
        }

        /// <summary>
        /// 价格
        /// </summary>        
        public decimal? Price
        {
            get;
            set;
        }

        /// <summary>
        /// 是否使用(0-禁用,1-使用)
        /// </summary>        
        public int? IsUse
        {
            get;
            set;
        }

        /// <summary>
        /// 是否显示(0-不显示,1-显示)
        /// </summary>        
        public int? IsShow
        {
            get;
            set;
        }

        /// <summary>
        /// 模板数据
        /// </summary>        
        public string TemplateData
        {
            get;
            set;
        }

        /// <summary>
        /// 排序
        /// </summary>        
        public int? SortNum
        {
            get;
            set;
        }

        /// <summary>
        /// 创建人
        /// </summary>        
        public int? CreateBy
        {
            get;
            set;
        }

        /// <summary>
        /// 创建时间
        /// </summary>        
        public DateTime? CreateDate
        {
            get;
            set;
        }

        /// <summary>
        /// 状态
        /// </summary>        
        public int? Status
        {
            get;
            set;
        }
    }
}
