﻿using VT.FW.DB;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.User
{   
     /// <summary>
     /// 菜单实体表
     /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Menu
    {
        /// <summary>
        /// 菜单编号
        /// </summary>        
        public int MenuId
        {
            get;
            set;
        }

        /// <summary>
        /// 菜单名称
        /// </summary>        
        public string MenuName
        {
            get;
            set;
        }

        /// <summary>
        /// 菜单连接
        /// </summary>        
        public string MenuUrl
        {
            get;
            set;
        }

        /// <summary>
        /// 菜单等级(1)
        /// </summary>        
        public int? MenuLevel
        {
            get;
            set;
        }

        /// <summary>
        /// 父级菜单编号(根节点为0)
        /// </summary>        
        public int? ParentId
        {
            get;
            set;
        }

        /// <summary>
        /// 图标
        /// </summary>        
        public string IconClass
        {
            get;
            set;
        }

        /// <summary>
        /// 状态
        /// </summary>        
        public int? Status
        {
            get;
            set;
        }

        /// <summary>
        /// 创建时间
        /// </summary>        
        public DateTime? CreateDate
        {
            get;
            set;
        }

        /// <summary>
        /// 排序
        /// </summary>
        public int SortNum { get; set; }
    }
}
