﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.Product;
using Mall.Model.Extend.Product;
using System.Linq;

namespace Mall.Repository.Product
{
    /// <summary>
    /// 课程下载仓储层
    /// </summary>
    public class RB_Goods_WK_DownLoadRepository : BaseRepository<RB_Goods_WK_DownLoad>
    {

        /// <summary>
        /// 列表
        /// </summary>
        /// <param name="dmodel">查询条件</param>
        /// <returns></returns>
        public List<RB_Goods_WK_DownLoad_Extend> GetList(RB_Goods_WK_DownLoad_Extend dmodel)
        {
            string where = $" 1=1";
            if (dmodel.Id > 0) {
                where += $@" and gc.{nameof(RB_Goods_WK_DownLoad.Id)}={dmodel.Id}";
            }
            if (dmodel.UserId > 0) {
                where += $@" and gc.{nameof(RB_Goods_WK_DownLoad.UserId)}={dmodel.UserId}";
            }
            if (dmodel.GoodsId > 0) {
                where += $@" and gc.{nameof(RB_Goods_WK_DownLoad.GoodsId)}={dmodel.GoodsId}";
            }
            if (dmodel.CourseId > 0) {
                where += $@" and gc.{nameof(RB_Goods_WK_DownLoad.CourseId)}={dmodel.CourseId}";
            }
            if (!string.IsNullOrEmpty(dmodel.GoodsIds)) {
                where += $@" and gc.{nameof(RB_Goods_WK_DownLoad.GoodsId)} in({dmodel.GoodsIds})";
            }
            if (!string.IsNullOrEmpty(dmodel.CourseIds)) {
                where += $@" and gc.{nameof(RB_Goods_WK_DownLoad.CourseId)} in({dmodel.CourseIds})";
            }
            
            string sql = $@"
SELECT gc.* FROM RB_Goods_WK_DownLoad gc 
WHERE {where} ORDER BY gc.Id desc ";
            return Get<RB_Goods_WK_DownLoad_Extend>(sql).ToList();
        }
    }
}
