﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Mall.Common.API;
using Mall.Common.Plugin;
using Mall.Model.Extend.GuideCar;
using Mall.Module.Product;
using Mall.WebApi.Filter;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;

namespace Mall.WebApi.Controllers.Product
{

    [Route("api/[controller]/[action]")]
    [ApiExceptionFilter]
    [ApiController]
    [EnableCors("AllowCors")]
    public class AppletGuideCarController : ControllerBase
    {
        private readonly GuideCarModule guideCarModule = new GuideCarModule();


        #region 商品详情
        /// <summary>
        /// 获取小程序商品详情
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetAppletSDGoodsInfo(object requestMsg)
        {
            var req = JsonConvert.DeserializeObject<RequestParm>(requestMsg.ToString());
            if (req.MallBaseId <= 0)
            {
                return ApiResult.ParamIsNull();
            }
            JObject prams = JObject.Parse(req.msg.ToString());
            int GoodsId = prams.GetInt("GoodsId", 0);
            if (GoodsId <= 0)
            {
                return ApiResult.ParamIsNull();
            }
            int UserId = req.UserId;

            var Robj = guideCarModule.GetAppletGoodsInfo_V2(GoodsId, UserId, req.SmallShopsId, req.TenantId, req.MallBaseId);
            return ApiResult.Success("", Robj);
        }
        #endregion

        #region 订单信息

        #endregion


        /// <summary>
        /// 获取详情
        /// </summary>
        /// <returns></returns>
        public ApiResult GetGuideCarGuideModel(object requestMsg)
        {
            var parms = JsonConvert.DeserializeObject<RequestParm>(requestMsg.ToString()); 
            var query = JsonConvert.DeserializeObject<RB_GuideCar_Guide_Extend>(parms.msg.ToString());
            query.TenantId = parms.TenantId;
            query.MallBaseId = parms.MallBaseId;
            var oldLogisticsModel = guideCarModule.GetGuideCarGuideModel(query);
            if (oldLogisticsModel == null)
            {
                oldLogisticsModel = new RB_GuideCar_Guide_Extend();
            }
            return ApiResult.Success("", oldLogisticsModel);
        }



        /// <summary>
        /// 获取详情
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetGuideCarModel(object requestMsg)
        {
            var parms = JsonConvert.DeserializeObject<RequestParm>(requestMsg.ToString());             
            var query = JsonConvert.DeserializeObject<RB_GuideCar_Car_Extend>(parms.msg.ToString());
            query.TenantId = parms.TenantId;
            query.MallBaseId = parms.MallBaseId;
            var oldLogisticsModel = guideCarModule.GetGuideCarModel(query);
            if (oldLogisticsModel == null)
            {
                oldLogisticsModel = new RB_GuideCar_Car_Extend();
            }
            return ApiResult.Success("", oldLogisticsModel);
        }
    }
}