﻿using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using System;
using System.Collections.Generic;
using System.IO;

namespace Mall.Common.Data
{
    /// <summary>
    /// 地区数据帮助类
    /// </summary>
    public class AreaDataHelper
    {
        static readonly string path = Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "Data\\Area.json");

        /// <summary>
        /// 地区节点集合
        /// </summary>
        public static List<Node> Nodes { get; set; }

       

  

        /// <summary>
        /// 获取地区列表
        /// </summary>
        /// <returns></returns>
        public static List<Node> GetAreaList()
        {
            if (Nodes != null && Nodes.Count > 0)
            {
                return Nodes;
            }
            try
            {
                //读取json文件  
                using (StreamReader file = new StreamReader(path))
                {
                    try
                    {
                        JsonSerializer serializer = new JsonSerializer();
                        Nodes = (List<Node>)serializer.Deserialize(file, typeof(List<Node>));
                        return Nodes;
                    }
                    catch
                    {
                        return null;
                    }
                }
            }
            catch
            {
                return null;
            }
        }
    }

    /// <summary>
    /// 地区节点
    /// </summary>
    public class Node
    {
        /// <summary>
        /// 编号
        /// </summary>
        public int I
        {
            get;
            set;
        }

        /// <summary>
        /// 名称
        /// </summary>        
        public string N
        {
            get;
            set;
        }

        /// <summary>
        /// 英文名称
        /// </summary>
        public string E { get; set; }

        /// <summary>
        /// 城市三码
        /// </summary>
        public string C { get; set; }

        /// <summary>
        /// 层级1-国家，2-省，3-市，4-区县
        /// </summary>
        public int L { get; set; }

        /// <summary>
        /// 父级编号
        /// </summary>
        public int P { get; set; }

        /// <summary>
        /// 状态
        /// </summary>
        public int S  { get; set; }

        public List<Node> Children { get; set; }
    }
}
