﻿using System;
using System.Collections.Generic;
using System.Text;
using VT.FW.DB;

namespace Mall.Model.Entity.Education
{
    /// <summary>
    /// 活动期数实体类
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "EduConnection")]
    public class RB_Activity_Periods
    {
        /// <summary>
        ///  编号
        /// </summary>
        public int Id { get; set; }

        /// <summary>
        /// 名称
        /// </summary>
        public string Name { get; set; }

        /// <summary>
        /// 期数
        /// </summary>
        public string Periods { get; set; }

        /// <summary>
        /// 创建人
        /// </summary>
        public int CreateBy { get; set; }

        /// <summary>
        /// 创建日期
        /// </summary>
        public DateTime CreateTime { get; set; }

        /// <summary>
        /// 累计金额
        /// </summary>
        public decimal SumPrice { get; set; }

        /// <summary>
        /// 集团编号
        /// </summary>
        public int Group_Id { get; set; }

        /// <summary>
        /// 关联财务单据ids
        /// </summary>
        public string Financials { get; set; }

        /// <summary>
        /// 已发放人员列表
        /// </summary>
        public string EmpIds { get; set; }

    }
}
