﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Common.Enum.Education;
using VT.FW.DB;

namespace Mall.Model.Entity.Education
{
    /// <summary>
    /// 财务收据配置实体类
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "EduConnection")]
    public class RB_Receipt_Config
    {
        /// <summary>
        /// Id
        /// </summary>
        public int Id { get; set; }

        /// <summary>
        /// 是否启用  1是  其他否
        /// </summary>
        public int Enable { get; set; }

        /// <summary>
        /// 使用的流程IDs 英文逗号分隔
        /// </summary>
        public string TempleteIds { get; set; }

        /// <summary>
        /// 章图片地址
        /// </summary>
        public string Images { get; set; }

        /// <summary>
        /// 集团编号
        /// </summary>
        public int Group_Id { get; set; }

        /// <summary>
        /// 创建人
        /// </summary>
        public int CreateBy { get; set; }

        /// <summary>
        /// 创建时间
        /// </summary>
        public DateTime CreateTime { get; set; }

        /// <summary>
        /// 修改人
        /// </summary>
        public int UpdateBy { get; set; }

        /// <summary>
        /// 修改时间
        /// </summary>
        public DateTime UpdateTime { get; set; }

    }
}
