﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.Miai;

namespace Mall.Model.Extend.Miai
{
    public class RB_MiAi_BaseInfo_Extend : RB_MiAi_BaseInfo
    {
        /// <summary>
        /// 相册
        /// </summary>
        public List<string> AlbumList { get; set; }


        public string Name { get; set; }


        public int Age { get; set; }

        /// <summary>
        /// 头像
        /// </summary>
        public string Photo { get; set; }

        /// <summary>
        /// 手机号码
        /// </summary>
        public string Moblie { get; set; }

        /// <summary>
        /// 指定用户id
        /// </summary>
        public string UserIds { get; set; }

        /// <summary>
        /// 用户所在分组
        /// </summary>
        public string UserGroupIds { get; set; }

        /// <summary>
        /// 查看指定分组
        /// </summary>
        public string LookGroupIds { get; set; }

        /// <summary>
        /// 0-指定用户，1-按照匹配度，2-按照热度，3-按照最新
        /// </summary>
        public int Sort { get; set; }

        /// <summary>
        /// 浏览权重
        /// </summary>
        public decimal BrowseRate { get; set; }


        /// <summary>
        /// 关注权重
        /// </summary>
        public decimal FollowRate { get; set; }


        /// <summary>
        /// 省名称
        /// </summary>
        public string PName { get; set; }
        /// <summary>
        /// 市名称
        /// </summary>
        public string CName { get; set; }
        /// <summary>
        /// 区名称
        /// </summary>
        public string DName { get; set; }


        /// <summary>
        /// 定位省名称
        /// </summary>
        public string DWPName { get; set; }
        /// <summary>
        /// 定位市名称
        /// </summary>
        public string DWCName { get; set; }
        /// <summary>
        /// 定位区名称
        /// </summary>
        public string DWDName { get; set; }

        /// <summary>
        /// 车
        /// </summary>
        public string CarInfoStr { get; set; }
        /// <summary>
        /// 年收入信息
        /// </summary>
        public string YearMoneyTypeStr { get; set; }




        /// <summary>
        /// 房信息
        /// </summary>
        public string HouseInfoStr { get; set; }
    }

    public class RB_MiaiMember_Extend : RB_MiAi_BaseInfo
    {
        /// <summary>
        /// 年龄
        /// </summary>
        public int Age { get; set; }

        /// <summary>
        /// 年龄
        /// </summary>
        public int EndAge { get; set; }


        /// <summary>
        /// 身高
        /// </summary>
        public decimal EndHeight { get; set; }

        /// <summary>
        /// 体重
        /// </summary>
        public decimal EndWeight { get; set; }


        /// <summary>
        /// 年收入
        /// </summary>
        public decimal EndYearMoney { get; set; }


        public string UserIds { get; set; }


        /// <summary>
        /// 查询条件的id
        /// </summary>
        public int QueryId { get; set; }

        /// <summary>
        /// 用户所在分组
        /// </summary>
        public string UserGroupIds { get; set; }
    }


}
