﻿using Mall.Model.Extend.TradePavilion;
using Mall.Repository.TradePavilion;
using Mall.Repository.User;
using System;
using System.Collections.Generic;
using System.Text;
using VT.FW.DB;

namespace Mall.Module.TradePavilion
{
    /// <summary>
    /// 心愿单处理类
    /// </summary>
    public class FirstShopWishModule
    {
        /// <summary>
        /// 心愿单仓储层对象
        /// </summary>
        private readonly RB_FirstShop_WishRepository firstShop_WishRepository = new RB_FirstShop_WishRepository();
        /// <summary>
        /// 用户
        /// </summary>
        private readonly RB_Member_UserRepository member_UserRepository = new RB_Member_UserRepository();
        /// <summary>
        /// 认证
        /// </summary>
        private readonly RB_CompanyRepository companyRepository = new RB_CompanyRepository();

        /// <summary>
        /// 获取心愿单分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_FirstShop_Wish_Extend> GetWishPageList(int pageIndex, int pageSize, out long rowsCount, RB_FirstShop_Wish_Extend query)
        {
            return firstShop_WishRepository.GetPageList(pageIndex, pageSize, out rowsCount, query);
        }

        /// <summary>
        /// 获取心愿单列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_FirstShop_Wish_Extend> GetWishList(RB_FirstShop_Wish_Extend query)
        {
            return firstShop_WishRepository.GetList(query);
        }

        /// <summary>
        /// 取消心愿单
        /// </summary>
        /// <param name="wishId"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public string DelFirstShopWishInfo(int wishId, int mallBaseId)
        {
            Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                { nameof(RB_FirstShop_Wish_Extend.Status),1}
            };
            List<WhereHelper> wheres = new List<WhereHelper>() {
                new WhereHelper(){
                     FiledName=nameof(RB_FirstShop_Wish_Extend.Id),
                      FiledValue=wishId,
                       OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                     FiledName= nameof(RB_FirstShop_Wish_Extend.MallBaseId),
                      FiledValue= mallBaseId,
                       OperatorEnum=OperatorEnum.Equal
                }
            };
            bool flag = firstShop_WishRepository.Update(keyValues, wheres);
            return flag ? "" : "取消失败";
        }

        /// <summary>
        /// 新增修改心愿单
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public string SetMyWishInfo(RB_FirstShop_Wish_Extend demodel)
        {
            //验证用户是否品牌方 并且已认证
            var cmodel = companyRepository.GetCompanyRepository(new RB_Company_Extend() { MallBaseId = demodel.MallBaseId, CreateBy = demodel.UserId });
            if (cmodel == null) { return "未申请认证，无法使用心愿单"; }
            if (cmodel.CompanyStatus != 1) { return "认证未审核通过，无法使用心愿单"; }
            if (cmodel.FirstShopType != 1) { return "非品牌方无法使用心愿单"; }

            if (demodel.Id > 0)
            {
                //修改
                Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                    { nameof(RB_FirstShop_Wish_Extend.BranchName),demodel.BranchName },
                    { nameof(RB_FirstShop_Wish_Extend.CarrierName),demodel.CarrierName },
                    { nameof(RB_FirstShop_Wish_Extend.Area),demodel.Area },
                    { nameof(RB_FirstShop_Wish_Extend.Description),demodel.Description },
                    { nameof(RB_FirstShop_Wish_Extend.NameCard),demodel.NameCard },
                    { nameof(RB_FirstShop_Wish_Extend.UpdateDate),demodel.UpdateDate },
                };
                List<WhereHelper> wheres = new List<WhereHelper>() {
                    new WhereHelper(){
                         FiledName=nameof(RB_FirstShop_Wish_Extend.Id),
                          FiledValue=demodel.Id,
                           OperatorEnum=OperatorEnum.Equal
                    }
                };
                bool flag = firstShop_WishRepository.Update(keyValues, wheres);
                return flag ? "" : "修改失败";
            }
            else {
                //新增
                bool flag = firstShop_WishRepository.Insert(demodel) > 0;
                return flag ? "" : "新增失败";
            }
        }

        /// <summary>
        /// 获取心愿单详情
        /// </summary>
        /// <param name="wishId"></param>
        /// <returns></returns>
        public RB_FirstShop_Wish_Extend GetMyWishInfo(int wishId)
        {
            return firstShop_WishRepository.GetEntity<RB_FirstShop_Wish_Extend>(wishId);
        }
    }
}
