﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mall.Model.Entity.Education;
using Mall.Model.Extend.Education;
using VT.FW.DB.Dapper;

namespace Mall.Repository.Education
{
    public class RB_Education_ActivitySummaryFileRepository : BaseRepository<RB_Education_ActivitySummaryFile>
    {

        /// <summary>
        /// 分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="dmodel">查询条件</param>
        /// <returns></returns>
        public List<RB_Education_ActivitySummaryFile_Extend> GetPageList(int pageIndex, int pageSize, out long rowCount, RB_Education_ActivitySummaryFile_Extend dmodel)
        {
            var parameters = new DynamicParameters();
            string where = $" 1=1 and {nameof(RB_Education_ActivitySummaryFile.Status)}=0";

            if (dmodel.TenantId > 0)
            {
                where += $@" and {nameof(RB_Education_ActivitySummaryFile.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and {nameof(RB_Education_ActivitySummaryFile.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.Id > 0)
            {
                where += $@" and {nameof(RB_Education_ActivitySummaryFile.Id)}={dmodel.Id}";
            }
            if (!string.IsNullOrEmpty(dmodel.Name))
            {
                where += $@" and {nameof(RB_Education_ActivitySummaryFile.Name)} like @Name ";
                parameters.Add("Name", "%" + dmodel.Name.Trim() + "%");
            }
            if (dmodel.Type > 0)
            {
                where += $@" and {nameof(RB_Education_ActivitySummaryFile.Type)}={dmodel.Type}";
            }
            if (dmodel.GroupId > 0)
            {
                where += $@" and {nameof(RB_Education_ActivitySummaryFile.GroupId)}={dmodel.GroupId}";
            }
            if (dmodel.ActivityId > 0)
            {
                where += $@" and {nameof(RB_Education_ActivitySummaryFile.ActivityId)}={dmodel.ActivityId}";
            }
            string sql = $@"select * from RB_Education_ActivitySummaryFile where {where} order by Id desc";
            return GetPage<RB_Education_ActivitySummaryFile_Extend>(pageIndex, pageSize, out rowCount, sql, parameters).ToList();
        }

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Education_ActivitySummaryFile_Extend> GetList(RB_Education_ActivitySummaryFile_Extend dmodel)
        {
            string where = $" 1=1 and {nameof(RB_Education_ActivitySummaryFile.Status)}=0";
            if (dmodel.TenantId > 0)
            {
                where += $@" and {nameof(RB_Education_ActivitySummaryFile.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and {nameof(RB_Education_ActivitySummaryFile.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.Id > 0)
            {
                where += $@" and {nameof(RB_Education_ActivitySummaryFile.Id)}={dmodel.Id}";
            }
            if (!string.IsNullOrEmpty(dmodel.MaterialIds))
            {
                where += $@" and {nameof(RB_Education_ActivitySummaryFile.Id)} in({dmodel.MaterialIds})";
            }
            if (!string.IsNullOrEmpty(dmodel.Name))
            {
                where += $@" and {nameof(RB_Education_ActivitySummaryFile.Name)} like '%{dmodel.Name}%'";
            }
            if (dmodel.Type > 0)
            {
                where += $@" and {nameof(RB_Education_ActivitySummaryFile.Type)}={dmodel.Type}";
            }
            if (dmodel.GroupId > 0)
            {
                where += $@" and {nameof(RB_Education_ActivitySummaryFile.GroupId)}={dmodel.GroupId}";
            }
            if (dmodel.ActivityId > 0)
            {
                where += $@" and {nameof(RB_Education_ActivitySummaryFile.ActivityId)}={dmodel.ActivityId}";
            }
            string sql = $@"select * from RB_Education_ActivitySummaryFile where {where} order by Id desc";
            return Get<RB_Education_ActivitySummaryFile_Extend>(sql).ToList();
        }

      

        /// <summary>
        /// 删除素材
        /// </summary>
        /// <param name="materialIds"></param>
        /// <param name="uid"></param>
        /// <param name="mallBaseId"></param>
        /// <param name="groupId"></param>
        /// <returns></returns>
        public bool DelMaterialInfo(string materialIds, string uid, int mallBaseId, int groupId = 0)
        {
            if (groupId > 0)
            {
                string sql1 = $@" Update RB_Education_ActivitySummaryFile Set Status=1 where GroupId ={groupId} and TenantId={uid} and MallBaseId={mallBaseId} and Status=0 ";
                return Execute(sql1) > 0;
            }
            string sql = $@" Update RB_Education_ActivitySummaryFile Set Status=1 where Id in({materialIds}) and TenantId={uid} and MallBaseId={mallBaseId} and Status=0 ";
            return Execute(sql) > 0;
        }

        /// <summary>
        /// 素材转移
        /// </summary>
        /// <param name="materialIds"></param>
        /// <param name="groupId"></param>
        /// <param name="uid"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public bool SetMaterialInfoTransfer(string materialIds, int groupId, string uid, int mallBaseId,int activityId)
        {
            string sql = $@" Update RB_Education_ActivitySummaryFile Set GroupId={groupId} where Id in({materialIds}) and TenantId={uid} and ActivityId={activityId} and MallBaseId={mallBaseId} and Status=0";
            return Execute(sql) > 0;
        }
    }
}
