﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mall.Model.Entity.Education;

namespace Mall.Repository.Education
{
    /// <summary>
    /// 评论违规记录
    /// </summary>
    public class RB_Education_ViolationLogRepository : BaseRepository<RB_Education_ViolationLog>
    {
        /// <summary>
        /// 获取用户的违规记录
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Education_ViolationLog> GetListRepository(RB_Education_ViolationLog query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT * FROM RB_Education_ViolationLog WHERE 1=1");
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_Education_ViolationLog.TenantId)}={query.TenantId}");
                }
                if (query.UserId > 0)
                {
                    builder.Append($" AND {nameof(RB_Education_ViolationLog.UserId)}={query.UserId}");
                }
                if (query.MallBaseId > 0)
                {
                    builder.Append($" AND {nameof(RB_Education_ViolationLog.MallBaseId)}={query.MallBaseId}");
                }
            }
            return Get<RB_Education_ViolationLog>(builder.ToString()).ToList();
        }
    }
}
