﻿using Mall.Common.Enum;
using Mall.Model.Entity.TradePavilion;
using Mall.Model.Extend.TradePavilion;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VT.FW.DB.Dapper;

namespace Mall.Repository.TradePavilion
{
    /// <summary>
    /// 心愿单仓储层
    /// </summary>
    public class RB_FirstShop_WishRepository : BaseRepository<RB_FirstShop_Wish>
    {
        /// <summary>
        /// 获取分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_FirstShop_Wish_Extend> GetPageList(int pageIndex, int pageSize, out long count, RB_FirstShop_Wish_Extend dmodel)
        {
            var parameters = new DynamicParameters();
            string where = $" 1=1";
            if (dmodel.TenantId > 0)
            {
                where += $@" and w.{nameof(RB_FirstShop_Wish.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and w.{nameof(RB_FirstShop_Wish.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.Status >= 0)
            {
                where += $@" and w.{nameof(RB_FirstShop_Wish.Status)}={dmodel.Status}";
            }
            if (dmodel.UserId > 0)
            {
                where += $@" and w.{nameof(RB_FirstShop_Wish.UserId)}={dmodel.UserId}";
            }
            if (!string.IsNullOrEmpty(dmodel.BranchName))
            {
                where += $@" and w.{nameof(RB_FirstShop_Wish.BranchName)} @BranchName";
                parameters.Add("BranchName", "%" + dmodel.BranchName + "%");
            }
            if (!string.IsNullOrEmpty(dmodel.CarrierName))
            {
                where += $@" and w.{nameof(RB_FirstShop_Wish.CarrierName)} @CarrierName";
                parameters.Add("BranchName", "%" + dmodel.CarrierName + "%");
            }


            string sql = $@"select w.*,u.Name as UserName from RB_FirstShop_Wish w
left join rb_member_user u on w.UserId = u.Id
where {where} order by w.Id desc
";
            return GetPage<RB_FirstShop_Wish_Extend>(pageIndex, pageSize, out count, sql, parameters).ToList();
        }

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_FirstShop_Wish_Extend> GetList(RB_FirstShop_Wish_Extend dmodel)
        {
            var parameters = new DynamicParameters();
            string where = $" 1=1";
            if (dmodel.TenantId > 0)
            {
                where += $@" and w.{nameof(RB_FirstShop_Wish.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and w.{nameof(RB_FirstShop_Wish.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.Status >= 0)
            {
                where += $@" and w.{nameof(RB_FirstShop_Wish.Status)}={dmodel.Status}";
            }
            if (dmodel.UserId > 0)
            {
                where += $@" and w.{nameof(RB_FirstShop_Wish.UserId)}={dmodel.UserId}";
            }
            if (!string.IsNullOrEmpty(dmodel.BranchName))
            {
                where += $@" and w.{nameof(RB_FirstShop_Wish.BranchName)} @BranchName";
                parameters.Add("BranchName", "%" + dmodel.BranchName + "%");
            }
            if (!string.IsNullOrEmpty(dmodel.CarrierName))
            {
                where += $@" and w.{nameof(RB_FirstShop_Wish.CarrierName)} @CarrierName";
                parameters.Add("BranchName", "%" + dmodel.CarrierName + "%");
            }


            string sql = $@"select w.*,u.Name as UserName from RB_FirstShop_Wish w
left join rb_member_user u on w.UserId = u.Id
where {where} order by w.Id desc
";
            return Get<RB_FirstShop_Wish_Extend>(sql, parameters).ToList();
        }

    }
}