﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.User;
using Mall.Model.Extend.User;
using System.Linq;
namespace Mall.Repository.User
{
    /// <summary>
    /// 小程序页面管理仓储层
    /// </summary>
    public class RB_Miniprogram_PageManageRepository : BaseRepository<RB_Miniprogram_PageManage>
    {

        /// <summary>
        /// 根据查询条件获取小程序页面管理列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Miniprogram_PageManage_Extend> GetListRepository(RB_Miniprogram_PageManage_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append(" SELECT * FROM RB_Miniprogram_PageManage WHERE 1=1 ");
            if (query != null)
            {
                if (query.QPageType > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Miniprogram_PageManage_Extend.PageType), query.QPageType);
                }
                if (query.PageName != null && !string.IsNullOrEmpty(query.PageName.Trim()))
                {
                    builder.AppendFormat(" AND {0} LIKE '%{1}%' ", nameof(RB_Miniprogram_PageManage_Extend.PageName), query.PageName);
                }
                if (query.Status >= 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Miniprogram_PageManage_Extend.Status), query.Status);
                }
            }
            builder.Append(" ORDER BY PageSort ");
            return Get<RB_Miniprogram_PageManage_Extend>(builder.ToString()).ToList();
        }

        /// <summary>
        /// 获取小程序页面管理分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Miniprogram_PageManage_Extend> GetPageListRepository(int pageIndex, int pageSize, out long rowCount, RB_Miniprogram_PageManage_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append(" SELECT * FROM RB_Miniprogram_PageManage WHERE 1=1 ");
            if (query != null)
            {
                if (query.QPageType > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Miniprogram_PageManage_Extend.PageType), query.QPageType);
                }
                if (query.PageName != null && !string.IsNullOrEmpty(query.PageName.Trim()))
                {
                    builder.AppendFormat(" AND {0} LIKE '%{1}%' ", nameof(RB_Miniprogram_PageManage_Extend.PageName), query.PageName);
                }
                if (query.Status >= 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Miniprogram_PageManage_Extend.Status), query.Status);
                }
            }
            builder.Append(" ORDER BY PageSort ");
            return GetPage<RB_Miniprogram_PageManage_Extend>(pageIndex, pageSize, out rowCount, builder.ToString()).ToList();
        }

        /// <summary>
        /// 根据条件获取小程序页面列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Miniprogram_PageManage_Extend> GetListExtRepository(RB_MiniProgram_Page_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append(@"
SELECT B.PageId, B.PageName,B.PageType,B.PageUrl,B.PageSort,B.IsParameter,B.ParameterValue,IFNULL(A.SelfPageName,'') AS SelfPageName,A.Id,B.TipText
FROM rb_miniprogram_page AS A INNER JOIN rb_miniprogram_pagemanage AS B ON A.PageId = B.PageId
WHERE B.`Status`= 0 ");
            if (query != null)
            {
                if (query.MallBaseId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_MiniProgram_Page_Extend.MallBaseId), query.MallBaseId);
                }
            }
            return Get<RB_Miniprogram_PageManage_Extend>(builder.ToString()).ToList();
        }
    }
}
