﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mall.Common.Plugin;
using Mall.Model.Entity.User;
using Mall.Model.Extend.MarketingCenter;
using Mall.Model.Extend.User;
using Mall.Repository;
using Mall.Repository.User;
using VT.FW.DB;

namespace Mall.Module.User
{
    /// <summary>
    /// 内容处理类
    /// </summary>
    public class ContentModule
    {
        /// <summary>
        /// 专题分类表仓储层对象
        /// </summary>
        private readonly RB_Topic_TypeRepository topic_TypeRepository = new RB_Topic_TypeRepository();

        /// <summary>
        /// 门店表仓储层对象
        /// </summary>
        private readonly RB_StoresRepository storesRepository = new RB_StoresRepository();

        /// <summary>
        /// 视频表仓储层对象
        /// </summary>
        private readonly RB_VideoRepository videoRepository = new RB_VideoRepository();

        /// <summary>
        /// 文章表仓储层对象
        /// </summary>
        private readonly RB_ArticleRepository articleRepository = new RB_ArticleRepository();

        /// <summary>
        /// 专题仓储层对象
        /// </summary>
        private readonly RB_TopicRepository topicRepository = new RB_TopicRepository();

        #region 专题分类

        /// <summary>
        /// 专题分类分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Topic_Type_Extend> GetTopicTypePageListModule(int pageIndex, int pageSize, out long rowCount, RB_Topic_Type_Extend query)
        {
            return topic_TypeRepository.GetTopicTypePageListRepository(pageIndex, pageSize, out rowCount, query);
        }

        /// <summary>
        /// 获取专题分类列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Topic_Type_Extend> GetTopicTypeListModule(RB_Topic_Type_Extend query)
        {
            return topic_TypeRepository.GetTopicTypeListRepository(query);
        }

        /// <summary>
        /// 新增修改专题分类
        /// </summary>
        /// <param name="extModel"></param>
        /// <returns></returns>
        public bool SetTopicTypeModule(RB_Topic_Type_Extend extModel)
        {
            bool flag;
            if (extModel.Id > 0)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    { nameof(RB_Topic_Type_Extend.TopicName),extModel.TopicName.Trim()},
                    { nameof(RB_Topic_Type_Extend.SortNum),extModel.SortNum},
                    { nameof(RB_Topic_Type_Extend.IsDisable),extModel.IsDisable},
                };
                flag = topic_TypeRepository.Update(fileds, new WhereHelper(nameof(RB_Topic_Type_Extend.Id), extModel.Id));
            }
            else
            {
                var newId = topic_TypeRepository.Insert(extModel);
                extModel.Id = newId;
                flag = newId > 0;
            }
            return flag;
        }

        /// <summary>
        /// 获取专题分类实体
        /// </summary>
        /// <param name="Id"></param>
        /// <returns></returns>
        public RB_Topic_Type_Extend GetTopicTypeModule(object Id)
        {
            return topic_TypeRepository.GetEntity<RB_Topic_Type_Extend>(Id);
        }

        /// <summary>
        /// 删除专题分类
        /// </summary>
        /// <param name="extModel"></param>
        /// <returns></returns>
        public bool RemoveTopicTypeModule(object Id)
        {
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                { nameof(RB_Topic_Type_Extend.Status),1},
            };
            bool flag = topic_TypeRepository.Update(fileds, new WhereHelper(nameof(RB_Topic_Type_Extend.Id), Id));
            return flag;
        }

        /// <summary>
        /// 删除专题分类
        /// </summary>
        /// <param name="Id">主键编号</param>
        /// <param name="IsDisable">是否禁用</param>
        /// <returns></returns>
        public bool UpdateTopicTypeStatusModule(object Id,int IsDisable)
        {
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                { nameof(RB_Topic_Type_Extend.IsDisable),IsDisable},
            };
            bool flag = topic_TypeRepository.Update(fileds, new WhereHelper(nameof(RB_Topic_Type_Extend.Id), Id));
            return flag;
        }
        #endregion

        #region 专题

        /// <summary>
        /// 专题分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Topic_Extend> GetTopicPageListModule(int pageIndex, int pageSize, out long rowCount, RB_Topic_Extend query)
        {
            return topicRepository.GetTopicPageListRepository(pageIndex, pageSize, out rowCount, query);
        }

        /// <summary>
        /// 获取专题列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Topic_Extend> GetTopicListModule(RB_Topic_Extend query)
        {
            return topicRepository.GetTopicListRepository(query);
        }

        /// <summary>
        /// 新增修改专题
        /// </summary>
        /// <param name="extModel"></param>
        /// <returns></returns>
        public bool SetTopicModule(RB_Topic_Extend extModel)
        {
            bool flag;
            if (extModel.Id > 0)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    { nameof(RB_Topic_Extend.Title),extModel.Title.Trim()},
                    { nameof(RB_Topic_Extend.FlexType),extModel.FlexType},
                    { nameof(RB_Topic_Extend.CoverImg),extModel.CoverImg},
                    { nameof(RB_Topic_Extend.Abstract),extModel.Abstract},
                    { nameof(RB_Topic_Extend.CustomTitle),extModel.CustomTitle},
                    { nameof(RB_Topic_Extend.CustomImg),extModel.CustomImg},
                    { nameof(RB_Topic_Extend.IsChoice),extModel.IsChoice},
                    { nameof(RB_Topic_Extend.TopicTypeId),extModel.TopicTypeId},
                    { nameof(RB_Topic_Extend.ReadNum),extModel.ReadNum},
                    { nameof(RB_Topic_Extend.SortNum),extModel.SortNum},
                    { nameof(RB_Topic_Extend.TemplateData),extModel.TemplateData},
                };
                flag = topicRepository.Update(fileds, new WhereHelper(nameof(RB_Topic_Extend.Id), extModel.Id));
            }
            else
            {
                var newId = topicRepository.Insert(extModel);
                extModel.Id = newId;
                flag = newId > 0;
            }
            return flag;
        }

        /// <summary>
        /// 获取专题实体
        /// </summary>
        /// <param name="Id"></param>
        /// <returns></returns>
        public RB_Topic_Extend GetTopicModule(object Id)
        {
            var extModel= topicRepository.GetEntity<RB_Topic_Extend>(Id);
            if (extModel.TemplateData != null && !string.IsNullOrEmpty(extModel.TemplateData))
            {
                extModel.ComponentDataList = JsonHelper.DeserializeObject<List<ComponentItem>>(extModel.TemplateData);
                if (extModel.ComponentDataList != null && extModel.ComponentDataList.Count > 0)
                {
                    foreach (var item in extModel.ComponentDataList)
                    {
                        switch (item.Id)
                        {
                            case "rubik": item.data = JsonHelper.DeserializeObject<rubikItem>(item.data.ToString()); break;
                            case "video": item.data = JsonHelper.DeserializeObject<videoItem>(item.data.ToString()); break;
                            case "image-text": item.data = JsonHelper.DeserializeObject<imagetextItem>(item.data.ToString()); break;
                        }
                    }
                }
            }
            else
            {
                extModel.ComponentDataList = new List<ComponentItem>();
            }
            return extModel;
        }

        /// <summary>
        /// 删除专题
        /// </summary>
        /// <param name="extModel"></param>
        /// <returns></returns>
        public bool RemoveTopicModule(object Id)
        {
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                { nameof(RB_Topic_Extend.Status),1},
            };
            bool flag = topicRepository.Update(fileds, new WhereHelper(nameof(RB_Topic_Extend.Id), Id));
            return flag;
        }
        #endregion

        #region 门店

        /// <summary>
        /// 门店分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Stores_Extend> GetStoresPageListModule(int pageIndex, int pageSize, out long rowCount, RB_Stores_Extend query)
        {
            return storesRepository.GetStoresPageListRepository(pageIndex, pageSize, out rowCount, query);
        }

        /// <summary>
        /// 门店分类列表
        /// </summary>
        /// <param name="query"></param>
        /// <param name="isFirst">是否取第一条</param>
        /// <returns></returns>
        public List<RB_Stores_Extend> GetStoresListModule(RB_Stores_Extend query, bool isFirst = false)
        {
            return storesRepository.GetStoresListRepository(query,isFirst:isFirst);
        }

        /// <summary>
        /// 获取门店
        /// </summary>
        /// <param name="query"></param>
        /// <param name="isFirst"></param>
        /// <returns></returns>
        public object GetStoresInfoModule(RB_Stores_Extend query)
        {
            var storeModel = GetStoresListModule(query, isFirst: true)?.FirstOrDefault();
            object result = new
            {
                storeId = storeModel?.Id,
                storeName = storeModel?.Name,
                storeAddress = storeModel?.Address,
                storeTel = storeModel?.Tel,
                distance = storeModel?.KM,
                storeCoverImg = storeModel?.CoverImg,
                storeNavImg = storeModel?.NavImg
            };
            return result;
        }

        /// <summary>
        /// 新增修改门店
        /// </summary>
        /// <param name="extModel"></param>
        /// <returns></returns>
        public bool SetStoresModule(RB_Stores_Extend extModel)
        {
            bool flag;
            if (!string.IsNullOrEmpty(extModel.LngLat))
            {
                var tempArray = extModel.LngLat.Split(",");
                if (tempArray != null && tempArray.Length == 2)
                {
                    float.TryParse(tempArray[0], out float Lng);
                    extModel.Lng = Lng;
                    float.TryParse(tempArray[1], out float Lat);
                    extModel.Lat = Lat;
                }
            }
            if (extModel.Id > 0)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    { nameof(RB_Stores_Extend.Name),extModel.Name.Trim()},
                    { nameof(RB_Stores_Extend.Tel),extModel.Tel},
                    { nameof(RB_Stores_Extend.Address),extModel.Address},
                    { nameof(RB_Stores_Extend.LngLat),extModel.LngLat},
                    { nameof(RB_Stores_Extend.Score),extModel.Score},
                    { nameof(RB_Stores_Extend.Intro),extModel.Intro},
                    { nameof(RB_Stores_Extend.CoverImg),extModel.CoverImg},
                    { nameof(RB_Stores_Extend.NavImg),extModel.NavImg},
                    { nameof(RB_Stores_Extend.StartTime),extModel.StartTime},
                    { nameof(RB_Stores_Extend.EndTime),extModel.EndTime},
                    { nameof(RB_Stores_Extend.IsAllDay),extModel.IsAllDay},
                    { nameof(RB_Stores_Extend.ServiceProject),extModel.ServiceProject},
                    { nameof(RB_Stores_Extend.Lng),extModel.Lng},
                    { nameof(RB_Stores_Extend.Lat),extModel.Lat},
                };
                flag = storesRepository.Update(fileds, new WhereHelper(nameof(RB_Stores_Extend.Id), extModel.Id));
            }
            else
            {
                var newId = storesRepository.Insert(extModel);
                extModel.Id = newId;
                flag = newId > 0;
            }
            return flag;
        }

        /// <summary>
        /// 获取门店实体
        /// </summary>
        /// <param name="Id"></param>
        /// <returns></returns>
        public RB_Stores_Extend GetStoresModule(object Id)
        {
            return storesRepository.GetEntity<RB_Stores_Extend>(Id);
        }

        /// <summary>
        /// 删除门店
        /// </summary>
        /// <param name="extModel"></param>
        /// <returns></returns>
        public bool RemoveStoresModule(object Id)
        {
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                { nameof(RB_Stores_Extend.Status),1},
            };
            bool flag = storesRepository.Update(fileds, new WhereHelper(nameof(RB_Stores_Extend.Id), Id));
            return flag;
        }

        #endregion

        #region 视频
        /// <summary>
        /// 视频分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Video_Extend> GetVideoPageListModule(int pageIndex, int pageSize, out long rowCount, RB_Video_Extend query)
        {
            return videoRepository.GetVideoPageListRepository(pageIndex, pageSize, out rowCount, query);
        }

        /// <summary>
        /// 获取视频列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Video_Extend> GetVideoListModule(RB_Video_Extend query)
        {
            return videoRepository.GetVideoListRepository(query);
        }

        /// <summary>
        /// 新增修改视频
        /// </summary>
        /// <param name="extModel"></param>
        /// <returns></returns>
        public bool SetVideoModule(RB_Video_Extend extModel)
        {
            bool flag;
            if (extModel.Id > 0)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    { nameof(RB_Video_Extend.Title),extModel.Title.Trim()},
                    { nameof(RB_Video_Extend.SourceType),extModel.SourceType},
                    { nameof(RB_Video_Extend.VedioUrl),extModel.VedioUrl},
                    { nameof(RB_Video_Extend.VedioCoverImg),extModel.VedioCoverImg},
                    { nameof(RB_Video_Extend.VedioIntro),extModel.VedioIntro},
                    { nameof(RB_Video_Extend.SortNum),extModel.SortNum},
                };
                flag = videoRepository.Update(fileds, new WhereHelper(nameof(RB_Video_Extend.Id), extModel.Id));
            }
            else
            {
                var newId = videoRepository.Insert(extModel);
                extModel.Id = newId;
                flag = newId > 0;
            }
            return flag;
        }

        /// <summary>
        /// 获取视频实体
        /// </summary>
        /// <param name="Id"></param>
        /// <returns></returns>
        public RB_Video_Extend GetVideoModule(object Id)
        {
            return videoRepository.GetEntity<RB_Video_Extend>(Id);
        }

        /// <summary>
        /// 删除视频
        /// </summary>
        /// <param name="extModel"></param>
        /// <returns></returns>
        public bool RemoveVideoModule(object Id)
        {
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                { nameof(RB_Video_Extend.Status),1},
            };
            bool flag = videoRepository.Update(fileds, new WhereHelper(nameof(RB_Video_Extend.Id), Id));
            return flag;
        }
        #endregion

        #region 文章

        /// <summary>
        /// 文章分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Article_Extend> GetArticlePageListModule(int pageIndex, int pageSize, out long rowCount, RB_Article_Extend query)
        {
            return articleRepository.GetArticlePageListRepository(pageIndex, pageSize, out rowCount, query);
        }

        /// <summary>
        /// 获取文章列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Article_Extend> GetArticleListModule(RB_Article_Extend query)
        {
            return articleRepository.GetArticleListRepository(query);
        }

        /// <summary>
        /// 新增修改文章
        /// </summary>
        /// <param name="extModel"></param>
        /// <returns></returns>
        public bool SetArticleModule(RB_Article_Extend extModel)
        {
            bool flag;
            if (extModel.Id > 0)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    { nameof(RB_Article_Extend.Title),extModel.Title.Trim()},
                    { nameof(RB_Article_Extend.SortNum),extModel.SortNum},
                    { nameof(RB_Article_Extend.IsDisable),extModel.IsDisable},
                    { nameof(RB_Article_Extend.Content),extModel.Content},
                };
                flag = articleRepository.Update(fileds, new WhereHelper(nameof(RB_Video_Extend.Id), extModel.Id));
            }
            else
            {
                var newId = articleRepository.Insert(extModel);
                extModel.Id = newId;
                flag = newId > 0;
            }
            return flag;
        }

        /// <summary>
        /// 获取文章实体
        /// </summary>
        /// <param name="Id"></param>
        /// <returns></returns>
        public RB_Article_Extend GetArticleModule(object Id)
        {
            return articleRepository.GetEntity<RB_Article_Extend>(Id);
        }

        /// <summary>
        /// 删除文章
        /// </summary>
        /// <param name="extModel"></param>
        /// <returns></returns>
        public bool RemoveArticleModule(object Id)
        {
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                { nameof(RB_Article_Extend.Status),1},
            };
            bool flag = articleRepository.Update(fileds, new WhereHelper(nameof(RB_Article_Extend.Id), Id));
            return flag;
        }

        /// <summary>
        /// 更新文章状态
        /// </summary>
        /// <param name="Id"></param>
        /// <param name="IsDisable"></param>
        /// <returns></returns>
        public bool UpdateArticleIsDisableModule(object Id,int IsDisable)
        {
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                { nameof(RB_Article_Extend.IsDisable),IsDisable},
            };
            bool flag = articleRepository.Update(fileds, new WhereHelper(nameof(RB_Article_Extend.Id), Id));
            return flag;
        }
        #endregion
    }
}
