﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.Product;
using Mall.Model.Extend.Product;
using System.Linq;

namespace Mall.Repository.Product
{
    /// <summary>
    /// 商品分类样式仓储层
    /// </summary>
    public class RB_Product_CategoryStyleRepository : BaseRepository<RB_Product_CategoryStyle>
    {

        /// <summary>
        /// 分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="dmodel">查询条件</param>
        /// <returns></returns>
        public List<RB_Product_CategoryStyle_Extend> GetPageList(int pageIndex, int pageSize, out long rowCount, RB_Product_CategoryStyle_Extend dmodel)
        {
            string where = $" 1=1 ";
            if (dmodel.TenantId > 0) {
                where += $@" and {nameof(RB_Product_CategoryStyle.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0) {
                where += $@" and {nameof(RB_Product_CategoryStyle.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.Id > 0) {
                where += $@" and {nameof(RB_Product_CategoryStyle.Id)}={dmodel.Id}";
            }

            string sql = $@"select * from RB_Product_CategoryStyle where {where} order by Id asc";
            return GetPage<RB_Product_CategoryStyle_Extend>(pageIndex, pageSize, out rowCount, sql).ToList();
        }

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Product_CategoryStyle_Extend> GetList(RB_Product_CategoryStyle_Extend dmodel)
        {
            string where = $" 1=1 ";
            if (dmodel.TenantId > 0)
            {
                where += $@" and {nameof(RB_Product_CategoryStyle_Extend.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and {nameof(RB_Product_CategoryStyle_Extend.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.Id > 0)
            {
                where += $@" and {nameof(RB_Product_CategoryStyle_Extend.Id)}={dmodel.Id}";
            }

            string sql = $@"select * from RB_Product_CategoryStyle where {where} order by Id asc";
            return Get<RB_Product_CategoryStyle_Extend>(sql).ToList();
        }
    }
}
